/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.collections.IteratorChain;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.ImplementationManager;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SinglePullJobDelegate
extends PullJobDelegate
implements SyncopeSinglePullExecutor {
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private TemplateUtils templateUtils;

    public List<ProvisioningReport> pull(Provision provision, Connector connector, String connObjectKey, String connObjectValue, Realm realm, PullTaskTO pullTaskTO) throws JobExecutionException {
        LOG.debug("Executing pull on {}", (Object)provision.getResource());
        ArrayList actions = new ArrayList();
        pullTaskTO.getActions().forEach(key -> {
            Implementation impl = this.implementationDAO.find(key);
            if (impl == null || impl.getType() != ImplementationType.PULL_ACTIONS) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", key);
            } else {
                try {
                    actions.add(ImplementationManager.build((Implementation)impl));
                }
                catch (Exception e) {
                    LOG.warn("While building {}", (Object)impl, (Object)e);
                }
            }
        });
        try {
            GroupPullResultHandler handler;
            Set linkinMappingItems = this.virSchemaDAO.findByProvision(provision).stream().map(virSchema -> virSchema.asLinkingMappingItem()).collect(Collectors.toSet());
            IteratorChain mapItems = new IteratorChain(provision.getMapping().getItems().iterator(), linkinMappingItems.iterator());
            OperationOptions options = MappingUtils.buildOperationOptions((Iterator<? extends Item>)mapItems);
            PullTask pullTask = (PullTask)this.entityFactory.newEntity(PullTask.class);
            pullTask.setResource(provision.getResource());
            pullTask.setMatchingRule(pullTaskTO.getMatchingRule() == null ? MatchingRule.UPDATE : pullTaskTO.getMatchingRule());
            pullTask.setUnmatchingRule(pullTaskTO.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : pullTaskTO.getUnmatchingRule());
            pullTask.setPullMode(PullMode.FILTERED_RECONCILIATION);
            pullTask.setPerformCreate(pullTaskTO.isPerformCreate());
            pullTask.setPerformUpdate(pullTaskTO.isPerformUpdate());
            pullTask.setPerformDelete(pullTaskTO.isPerformDelete());
            pullTask.setSyncStatus(pullTaskTO.isSyncStatus());
            pullTask.setDestinationRealm(realm);
            pullTask.setRemediation(pullTaskTO.isRemediation());
            this.templateUtils.check(pullTaskTO.getTemplates(), ClientExceptionType.InvalidPullTask);
            pullTaskTO.getTemplates().forEach((type, template) -> {
                AnyType anyType = this.anyTypeDAO.find(type);
                if (anyType == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", type);
                } else {
                    AnyTemplatePullTask anyTemplate = pullTask.getTemplate(anyType).orElse(null);
                    if (anyTemplate == null) {
                        anyTemplate = (AnyTemplatePullTask)this.entityFactory.newEntity(AnyTemplatePullTask.class);
                        anyTemplate.setAnyType(anyType);
                        anyTemplate.setPullTask(pullTask);
                        pullTask.add(anyTemplate);
                    }
                    anyTemplate.set(template);
                }
            });
            this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pullTask);
            this.profile.setDryRun(false);
            this.profile.setConflictResolutionAction(ConflictResolutionAction.FIRSTMATCH);
            this.profile.getActions().addAll(actions);
            for (PullActions action : actions) {
                action.beforeAll(this.profile);
            }
            GroupPullResultHandler ghandler = this.buildGroupHandler();
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = ghandler;
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            handler.setPullExecutor((SyncopePullExecutor)this);
            connector.filteredReconciliation(provision.getObjectClass(), (ReconFilterBuilder)new AccountReconciliationFilterBuilder(connObjectKey, connObjectValue), (SyncResultsHandler)handler, options);
            Optional userProvision = provision.getResource().getProvision(this.anyTypeDAO.findUser());
            boolean userIgnoreCaseMatch = userProvision.isPresent() ? ((Provision)userProvision.get()).isIgnoreCaseMatch() : false;
            Optional groupProvision = provision.getResource().getProvision(this.anyTypeDAO.findGroup());
            boolean groupIgnoreCaseMatch = groupProvision.isPresent() ? ((Provision)groupProvision.get()).isIgnoreCaseMatch() : false;
            try {
                this.setGroupOwners(ghandler, userIgnoreCaseMatch, groupIgnoreCaseMatch);
            }
            catch (Exception e) {
                LOG.error("While setting group owners", (Throwable)e);
            }
            for (PullActions action : actions) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pulling from connector", (Throwable)e);
        }
    }

    class AccountReconciliationFilterBuilder
    implements ReconFilterBuilder {
        private final String key;
        private final String value;

        AccountReconciliationFilterBuilder(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Filter build() {
            return FilterBuilder.equalTo((Attribute)AttributeBuilder.build((String)this.key, (Object[])new Object[]{this.value}));
        }
    }
}

