/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.attrvalue.validation.ParsingValidationException;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PullCorrelationRule;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.policy.PullCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnitItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.java.IntAttrNameParser;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ImplementationManager;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class PullUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PullUtils.class);
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;
    @Autowired
    private IntAttrNameParser intAttrNameParser;

    public Optional<String> match(AnyType anyType, String name, ExternalResource resource, Connector connector, boolean ignoreCaseMatch) {
        Optional provision = resource.getProvision(anyType);
        if (!provision.isPresent()) {
            return Optional.empty();
        }
        Optional<String> result = Optional.empty();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
        final ArrayList found = new ArrayList();
        Name nameAttr = new Name(name);
        connector.search(((Provision)provision.get()).getObjectClass(), ignoreCaseMatch ? FilterBuilder.equalsIgnoreCase((Attribute)nameAttr) : FilterBuilder.equalTo((Attribute)nameAttr), new SearchResultsHandler(){

            public void handleResult(SearchResult result) {
            }

            public boolean handle(ConnectorObject connectorObject) {
                return found.add(connectorObject);
            }
        }, MappingUtils.buildOperationOptions(MappingUtils.getPullItems(((Provision)provision.get()).getMapping().getItems()).iterator()));
        if (found.isEmpty()) {
            LOG.debug("No {} found on {} with __NAME__ {}", new Object[]{((Provision)provision.get()).getObjectClass(), resource, name});
        } else {
            if (found.size() > 1) {
                LOG.warn("More than one {} found on {} with __NAME__ {} - taking first only", new Object[]{((Provision)provision.get()).getObjectClass(), resource, name});
            }
            ConnectorObject connObj = (ConnectorObject)found.iterator().next();
            try {
                List<String> anyKeys = this.match(connObj, (Provision)provision.get(), anyUtils);
                if (anyKeys.isEmpty()) {
                    LOG.debug("No matching {} found for {}, aborting", (Object)anyUtils.anyTypeKind(), (Object)connObj);
                } else {
                    if (anyKeys.size() > 1) {
                        LOG.warn("More than one {} found {} - taking first only", (Object)anyUtils.anyTypeKind(), anyKeys);
                    }
                    result = Optional.ofNullable(anyKeys.iterator().next());
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn(e.getMessage());
            }
        }
        return result;
    }

    private List<String> findByConnObjectKey(ConnectorObject connObj, Provision provision, AnyUtils anyUtils) {
        ArrayList<String> result;
        block32: {
            IntAttrName intAttrName;
            String connObjectKey;
            block31: {
                Object connObjectKeyAttr;
                connObjectKey = null;
                Optional<? extends MappingItem> connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
                if (connObjectKeyItem.isPresent() && (connObjectKeyAttr = connObj.getAttributeByName(connObjectKeyItem.get().getExtAttrName())) != null) {
                    connObjectKey = AttributeUtil.getStringValue((Attribute)connObjectKeyAttr);
                }
                if (connObjectKey == null) {
                    return Collections.emptyList();
                }
                for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)connObjectKeyItem.get())) {
                    List output = transformer.beforePull((Item)connObjectKeyItem.get(), null, Collections.singletonList(connObjectKey));
                    if (output == null || output.isEmpty()) continue;
                    connObjectKey = output.get(0).toString();
                }
                result = new ArrayList<String>();
                try {
                    intAttrName = this.intAttrNameParser.parse(connObjectKeyItem.get().getIntAttrName(), provision.getAnyType().getKind());
                }
                catch (ParseException e) {
                    LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)connObjectKeyItem.get().getIntAttrName(), (Object)e);
                    return result;
                }
                if (intAttrName.getField() == null) break block31;
                switch (intAttrName.getField()) {
                    case "key": {
                        Any any = anyUtils.dao().find(connObjectKey);
                        if (any == null) break;
                        result.add(any.getKey());
                        break;
                    }
                    case "username": {
                        if (provision.getAnyType().getKind() == AnyTypeKind.USER && provision.isIgnoreCaseMatch()) {
                            AnyCond cond = new AnyCond(AttributeCond.Type.IEQ);
                            cond.setSchema("username");
                            cond.setExpression(connObjectKey);
                            result.addAll(this.searchDAO.search(SearchCond.getLeafCond((AttributeCond)cond), AnyTypeKind.USER).stream().map(Entity::getKey).collect(Collectors.toList()));
                            break;
                        }
                        User user = this.userDAO.findByUsername(connObjectKey);
                        if (user != null) {
                            result.add(user.getKey());
                            break;
                        }
                        break block32;
                    }
                    case "name": {
                        AnyCond cond;
                        if (provision.getAnyType().getKind() == AnyTypeKind.GROUP && provision.isIgnoreCaseMatch()) {
                            cond = new AnyCond(AttributeCond.Type.IEQ);
                            cond.setSchema("name");
                            cond.setExpression(connObjectKey);
                            result.addAll(this.searchDAO.search(SearchCond.getLeafCond((AttributeCond)cond), AnyTypeKind.GROUP).stream().map(Entity::getKey).collect(Collectors.toList()));
                        } else {
                            Group group = this.groupDAO.findByName(connObjectKey);
                            if (group != null) {
                                result.add(group.getKey());
                            }
                        }
                        if (provision.getAnyType().getKind() == AnyTypeKind.ANY_OBJECT && provision.isIgnoreCaseMatch()) {
                            cond = new AnyCond(AttributeCond.Type.IEQ);
                            cond.setSchema("name");
                            cond.setExpression(connObjectKey);
                            result.addAll(this.searchDAO.search(SearchCond.getLeafCond((AttributeCond)cond), AnyTypeKind.ANY_OBJECT).stream().map(Entity::getKey).collect(Collectors.toList()));
                            break;
                        }
                        AnyObject anyObject = this.anyObjectDAO.findByName(connObjectKey);
                        if (anyObject != null) {
                            result.add(anyObject.getKey());
                            break;
                        }
                        break block32;
                    }
                }
                break block32;
            }
            if (intAttrName.getSchemaType() != null) {
                switch (intAttrName.getSchemaType()) {
                    case PLAIN: {
                        PlainAttrValue value = anyUtils.newPlainAttrValue();
                        PlainSchema schema = (PlainSchema)this.plainSchemaDAO.find(intAttrName.getSchemaName());
                        if (schema == null) {
                            value.setStringValue(connObjectKey);
                        } else {
                            try {
                                value.parseValue(schema, connObjectKey);
                            }
                            catch (ParsingValidationException e) {
                                LOG.error("While parsing provided __UID__ {}", (Object)value, (Object)e);
                                value.setStringValue(connObjectKey);
                            }
                        }
                        result.addAll(anyUtils.dao().findByPlainAttrValue(intAttrName.getSchemaName(), value, provision.isIgnoreCaseMatch()).stream().map(Entity::getKey).collect(Collectors.toList()));
                        break;
                    }
                    case DERIVED: {
                        result.addAll(anyUtils.dao().findByDerAttrValue(intAttrName.getSchemaName(), connObjectKey, provision.isIgnoreCaseMatch()).stream().map(Entity::getKey).collect(Collectors.toList()));
                        break;
                    }
                }
            }
        }
        return result;
    }

    private List<String> findByCorrelationRule(ConnectorObject connObj, Provision provision, PullCorrelationRule rule, AnyTypeKind type) {
        return this.searchDAO.search(rule.getSearchCond(connObj, provision), type).stream().map(Entity::getKey).collect(Collectors.toList());
    }

    public List<String> match(ConnectorObject connObj, Provision provision, AnyUtils anyUtils) {
        Optional correlationRule = provision.getResource().getPullPolicy() == null ? Optional.empty() : provision.getResource().getPullPolicy().getCorrelationRule(provision.getAnyType());
        Optional rule = Optional.empty();
        if (correlationRule.isPresent()) {
            try {
                rule = ImplementationManager.buildPullCorrelationRule((Implementation)((PullCorrelationRuleEntity)correlationRule.get()).getImplementation());
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)((PullCorrelationRuleEntity)correlationRule.get()).getImplementation(), (Object)e);
            }
        }
        try {
            return rule.isPresent() ? this.findByCorrelationRule(connObj, provision, (PullCorrelationRule)rule.get(), anyUtils.anyTypeKind()) : this.findByConnObjectKey(connObj, provision, anyUtils);
        }
        catch (RuntimeException e) {
            LOG.error("Could not match {} with any existing {}", new Object[]{connObj, provision.getAnyType(), e});
            return Collections.emptyList();
        }
    }

    public List<String> match(ConnectorObject connObj, OrgUnit orgUnit) {
        Object connObjectKeyAttr;
        String connObjectKey = null;
        Optional connObjectKeyItem = orgUnit.getConnObjectKeyItem();
        if (connObjectKeyItem.isPresent() && (connObjectKeyAttr = connObj.getAttributeByName(((OrgUnitItem)connObjectKeyItem.get()).getExtAttrName())) != null) {
            connObjectKey = AttributeUtil.getStringValue((Attribute)connObjectKeyAttr);
        }
        if (connObjectKey == null) {
            return Collections.emptyList();
        }
        for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)connObjectKeyItem.get())) {
            List output = transformer.beforePull((Item)connObjectKeyItem.get(), null, Collections.singletonList(connObjectKey));
            if (output == null || output.isEmpty()) continue;
            connObjectKey = output.get(0).toString();
        }
        ArrayList<String> result = new ArrayList<String>();
        switch (((OrgUnitItem)connObjectKeyItem.get()).getIntAttrName()) {
            case "key": {
                Realm realm = this.realmDAO.find(connObjectKey);
                if (realm == null) break;
                result.add(realm.getKey());
                break;
            }
            case "name": {
                if (orgUnit.isIgnoreCaseMatch()) {
                    String realmName = connObjectKey;
                    result.addAll(this.realmDAO.findAll().stream().filter(r -> r.getName().equalsIgnoreCase(realmName)).map(Entity::getKey).collect(Collectors.toList()));
                    break;
                }
                result.addAll(this.realmDAO.findByName(connObjectKey).stream().map(Entity::getKey).collect(Collectors.toList()));
                break;
            }
            case "fullpath": {
                Realm realm = this.realmDAO.findByFullPath(connObjectKey);
                if (realm == null) break;
                result.add(realm.getKey());
                break;
            }
        }
        return result;
    }

    public Boolean readEnabled(ConnectorObject connectorObject, ProvisioningTask task) {
        Attribute status;
        Boolean enabled = null;
        if (task.isSyncStatus() && (status = AttributeUtil.find((String)OperationalAttributes.ENABLE_NAME, (Set)connectorObject.getAttributes())) != null && status.getValue() != null && !status.getValue().isEmpty()) {
            enabled = (Boolean)status.getValue().get(0);
        }
        return enabled;
    }
}

