/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.syncope.common.lib.collections.IteratorChain;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.UserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultAnyObjectPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultGroupPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultRealmPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultUserPullResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PullUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.ImplementationManager;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class PullJobDelegate
extends AbstractProvisioningJobDelegate<PullTask>
implements SyncopePullExecutor {
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected VirSchemaDAO virSchemaDAO;
    @Autowired
    protected PullUtils pullUtils;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;
    protected final Map<ObjectClass, SyncToken> latestSyncTokens = new HashMap<ObjectClass, SyncToken>();
    protected final Map<ObjectClass, MutablePair<Integer, String>> handled = new HashMap<ObjectClass, MutablePair<Integer, String>>();
    protected ProvisioningProfile<PullTask, PullActions> profile;

    public void setLatestSyncToken(ObjectClass objectClass, SyncToken latestSyncToken) {
        this.latestSyncTokens.put(objectClass, latestSyncToken);
    }

    public void reportHandled(ObjectClass objectClass, Name name) {
        MutablePair pair = this.handled.get(objectClass);
        if (pair == null) {
            pair = MutablePair.of((Object)0, null);
            this.handled.put(objectClass, (MutablePair<Integer, String>)pair);
        }
        pair.setLeft((Object)((Integer)pair.getLeft() + 1));
        pair.setRight((Object)name.getNameValue());
    }

    public boolean wasInterruptRequested() {
        return this.interrupt;
    }

    public void setInterrupted() {
        this.interrupted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String currentStatus() {
        AtomicReference atomicReference = this.status;
        synchronized (atomicReference) {
            if (!this.handled.isEmpty()) {
                StringBuilder builder = new StringBuilder("Processed:\n");
                this.handled.forEach((key, value) -> builder.append(' ').append(value.getLeft()).append('\t').append(key.getObjectClassValue()).append(" / latest: ").append((String)value.getRight()).append('\n'));
                this.status.set(builder.toString());
            }
        }
        return (String)this.status.get();
    }

    protected void setGroupOwners(GroupPullResultHandler ghandler, boolean userIgnoreCaseMatch, boolean groupIgnoreCaseMatch) {
        ghandler.getGroupOwnerMap().entrySet().stream().map(entry -> {
            Group group = (Group)this.groupDAO.find((String)entry.getKey());
            if (group == null) {
                throw new NotFoundException("Group " + (String)entry.getKey());
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) {
                group.setGroupOwner(null);
                group.setUserOwner(null);
            } else {
                Optional<String> userKey = this.pullUtils.match(this.anyTypeDAO.findUser(), (String)entry.getValue(), ((PullTask)ghandler.getProfile().getTask()).getResource(), ghandler.getProfile().getConnector(), userIgnoreCaseMatch);
                if (userKey.isPresent()) {
                    group.setUserOwner((User)this.userDAO.find(userKey.get()));
                } else {
                    this.pullUtils.match(this.anyTypeDAO.findGroup(), (String)entry.getValue(), ((PullTask)ghandler.getProfile().getTask()).getResource(), ghandler.getProfile().getConnector(), groupIgnoreCaseMatch).ifPresent(groupKey -> group.setGroupOwner((Group)this.groupDAO.find(groupKey)));
                }
            }
            return group;
        }).forEachOrdered(group -> this.groupDAO.save((Any)group));
    }

    protected RealmPullResultHandler buildRealmHandler() {
        return (RealmPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultRealmPullResultHandler.class, 1, false);
    }

    protected AnyObjectPullResultHandler buildAnyObjectHandler() {
        return (AnyObjectPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultAnyObjectPullResultHandler.class, 1, false);
    }

    protected UserPullResultHandler buildUserHandler() {
        return (UserPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultUserPullResultHandler.class, 1, false);
    }

    protected GroupPullResultHandler buildGroupHandler() {
        GroupPullResultHandler handler = (GroupPullResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultGroupPullResultHandler.class, 1, false);
        handler.setProfile(this.profile);
        handler.setPullExecutor((SyncopePullExecutor)this);
        return handler;
    }

    @Override
    protected String doExecuteProvisioning(PullTask pullTask, Connector connector, boolean dryRun) throws JobExecutionException {
        LOG.debug("Executing pull on {}", (Object)pullTask.getResource());
        ArrayList actions = new ArrayList();
        pullTask.getActions().forEach(impl -> {
            try {
                actions.add(ImplementationManager.build((Implementation)impl));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pullTask);
        this.profile.getActions().addAll(actions);
        this.profile.setDryRun(dryRun);
        this.profile.setConflictResolutionAction(pullTask.getResource().getPullPolicy() == null ? ConflictResolutionAction.IGNORE : pullTask.getResource().getPullPolicy().getConflictResolutionAction());
        this.latestSyncTokens.clear();
        if (!this.profile.isDryRun()) {
            for (PullActions action : actions) {
                action.beforeAll(this.profile);
            }
        }
        this.status.set("Initialization completed");
        if (pullTask.getResource().getOrgUnit() != null) {
            this.status.set("Pulling " + pullTask.getResource().getOrgUnit().getObjectClass().getObjectClassValue());
            OrgUnit orgUnit = pullTask.getResource().getOrgUnit();
            OperationOptions options = MappingUtils.buildOperationOptions(MappingUtils.getPullItems(orgUnit.getItems()).iterator());
            RealmPullResultHandler handler = this.buildRealmHandler();
            handler.setProfile(this.profile);
            handler.setPullExecutor((SyncopePullExecutor)this);
            try {
                switch (pullTask.getPullMode()) {
                    case INCREMENTAL: {
                        if (!dryRun) {
                            this.latestSyncTokens.put(orgUnit.getObjectClass(), orgUnit.getSyncToken());
                        }
                        connector.sync(orgUnit.getObjectClass(), orgUnit.getSyncToken(), (SyncResultsHandler)handler, options);
                        if (!dryRun) {
                            orgUnit.setSyncToken(this.latestSyncTokens.get(orgUnit.getObjectClass()));
                            this.resourceDAO.save(orgUnit.getResource());
                        }
                        break;
                    }
                    case FILTERED_RECONCILIATION: {
                        ReconFilterBuilder filterBuilder = (ReconFilterBuilder)ImplementationManager.build((Implementation)pullTask.getReconFilterBuilder());
                        connector.filteredReconciliation(orgUnit.getObjectClass(), filterBuilder, (SyncResultsHandler)handler, options);
                        break;
                    }
                    default: {
                        connector.fullReconciliation(orgUnit.getObjectClass(), (SyncResultsHandler)handler, options);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                throw new JobExecutionException("While pulling from connector", t);
            }
        }
        GroupPullResultHandler ghandler = this.buildGroupHandler();
        boolean userIgnoreCaseMatch = false;
        boolean groupIgnoreCaseMatch = false;
        for (Provision provision : pullTask.getResource().getProvisions()) {
            GroupPullResultHandler handler;
            if (provision.getMapping() == null) continue;
            if (provision.getAnyType().getKind() == AnyTypeKind.USER) {
                userIgnoreCaseMatch = provision.isIgnoreCaseMatch();
            } else if (provision.getAnyType().getKind() == AnyTypeKind.GROUP) {
                groupIgnoreCaseMatch = provision.isIgnoreCaseMatch();
            }
            this.status.set("Pulling " + provision.getObjectClass().getObjectClassValue());
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = ghandler;
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            handler.setPullExecutor((SyncopePullExecutor)this);
            try {
                Set linkingMappingItems = this.virSchemaDAO.findByProvision(provision).stream().map(schema -> schema.asLinkingMappingItem()).collect(Collectors.toSet());
                IteratorChain mapItems = new IteratorChain(provision.getMapping().getItems().iterator(), linkingMappingItems.iterator());
                OperationOptions options = MappingUtils.buildOperationOptions((Iterator<? extends Item>)mapItems);
                switch (pullTask.getPullMode()) {
                    case INCREMENTAL: {
                        if (!dryRun) {
                            this.latestSyncTokens.put(provision.getObjectClass(), provision.getSyncToken());
                        }
                        connector.sync(provision.getObjectClass(), provision.getSyncToken(), (SyncResultsHandler)handler, options);
                        if (dryRun) break;
                        provision.setSyncToken(this.latestSyncTokens.get(provision.getObjectClass()));
                        this.resourceDAO.save(provision.getResource());
                        break;
                    }
                    case FILTERED_RECONCILIATION: {
                        ReconFilterBuilder filterBuilder = (ReconFilterBuilder)ImplementationManager.build((Implementation)pullTask.getReconFilterBuilder());
                        connector.filteredReconciliation(provision.getObjectClass(), filterBuilder, (SyncResultsHandler)handler, options);
                        break;
                    }
                    default: {
                        connector.fullReconciliation(provision.getObjectClass(), (SyncResultsHandler)handler, options);
                    }
                }
                if (provision.getUidOnCreate() == null) continue;
                AnyUtils anyUtils = this.anyUtilsFactory.getInstance(provision.getAnyType().getKind());
                this.profile.getResults().stream().filter(result -> result.getUidValue() != null && result.getOperation() == ResourceOperation.CREATE).forEach(result -> anyUtils.addAttr(result.getKey(), provision.getUidOnCreate(), result.getUidValue()));
            }
            catch (Throwable t) {
                throw new JobExecutionException("While pulling from connector", t);
            }
        }
        try {
            this.setGroupOwners(ghandler, userIgnoreCaseMatch, groupIgnoreCaseMatch);
        }
        catch (Exception e) {
            LOG.error("While setting group owners", (Throwable)e);
        }
        if (!this.profile.isDryRun()) {
            for (PullActions action : actions) {
                action.afterAll(this.profile);
            }
        }
        this.status.set("Pull done");
        String result2 = this.createReport(this.profile.getResults(), pullTask.getResource(), dryRun);
        LOG.debug("Pull result: {}", (Object)result2);
        return result2;
    }
}

