/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.api.pushpull.IgnoreProvisionException;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.java.job.AfterHandlingJob;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationReporter;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractSyncopeResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PushUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractPushResultHandler
extends AbstractSyncopeResultHandler<PushTask, PushActions>
implements SyncopePushResultHandler {
    @Autowired
    protected PushUtils pushUtils;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected MappingManager mappingManager;
    @Autowired
    protected SchedulerFactoryBean scheduler;

    protected abstract String getName(Any<?> var1);

    protected void reportPropagation(ProvisioningReport result, PropagationReporter reporter) {
        if (!reporter.getStatuses().isEmpty()) {
            result.setStatus(this.toProvisioningReportStatus(((PropagationStatus)reporter.getStatuses().get(0)).getStatus()));
            result.setMessage(((PropagationStatus)reporter.getStatuses().get(0)).getFailureReason());
        }
    }

    protected void update(Any<?> any, Boolean enable, ConnectorObject beforeObj, ProvisioningReport result) {
        boolean changepwd = any instanceof User;
        List ownedResources = this.getAnyUtils().getAllResources(any).stream().map(Entity::getKey).collect(Collectors.toList());
        ArrayList noPropResources = new ArrayList(ownedResources);
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.UPDATE, ((PushTask)this.profile.getTask()).getResource().getKey());
        propByRes.addOldConnObjectKey(((PushTask)this.profile.getTask()).getResource().getKey(), beforeObj.getUid().getUidValue());
        List taskInfos = this.propagationManager.getUpdateTasks(any.getType().getKind(), any.getKey(), changepwd, enable, propByRes, null, noPropResources);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.get(0)).setBeforeObj(Optional.of(beforeObj));
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.get(0), (PropagationReporter)reporter);
            this.reportPropagation(result, reporter);
        }
    }

    protected void deprovision(Any<?> any, ConnectorObject beforeObj, ProvisioningReport result) {
        AnyTO before = this.getAnyTO(any.getKey());
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.DELETE, ((PushTask)this.profile.getTask()).getResource().getKey());
        propByRes.addOldConnObjectKey(((PushTask)this.profile.getTask()).getResource().getKey(), beforeObj.getUid().getUidValue());
        List taskInfos = this.propagationManager.getDeleteTasks(any.getType().getKind(), any.getKey(), propByRes, noPropResources);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.get(0)).setBeforeObj(Optional.of(beforeObj));
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.get(0), (PropagationReporter)reporter);
            this.reportPropagation(result, reporter);
        }
    }

    protected void provision(Any<?> any, Boolean enable, ProvisioningReport result) {
        AnyTO before = this.getAnyTO(any.getKey());
        ArrayList noPropResources = new ArrayList(before.getResources());
        noPropResources.remove(((PushTask)this.profile.getTask()).getResource().getKey());
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.add(ResourceOperation.CREATE, ((PushTask)this.profile.getTask()).getResource().getKey());
        List taskInfos = this.propagationManager.getCreateTasks(any.getType().getKind(), any.getKey(), enable, propByRes, (Collection)before.getVirAttrs(), noPropResources);
        if (!taskInfos.isEmpty()) {
            ((PropagationTaskInfo)taskInfos.get(0)).setBeforeObj(Optional.ofNullable(null));
            DefaultPropagationReporter reporter = new DefaultPropagationReporter();
            this.taskExecutor.execute((PropagationTaskInfo)taskInfos.get(0), (PropagationReporter)reporter);
            this.reportPropagation(result, reporter);
        }
    }

    protected void link(Any<?> any, boolean unlink, ProvisioningReport result) {
        AnyPatch patch = this.getAnyUtils().newAnyPatch(any.getKey());
        patch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(unlink ? PatchOperation.DELETE : PatchOperation.ADD_REPLACE)).value((Object)((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.update(patch);
        result.setStatus(ProvisioningReport.Status.SUCCESS);
    }

    protected void unassign(Any<?> any, ConnectorObject beforeObj, ProvisioningReport result) {
        AnyPatch patch = this.getAnyUtils().newAnyPatch(any.getKey());
        patch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value((Object)((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.update(patch);
        this.deprovision(any, beforeObj, result);
    }

    protected void assign(Any<?> any, Boolean enabled, ProvisioningReport result) {
        AnyPatch patch = this.getAnyUtils().newAnyPatch(any.getKey());
        patch.getResources().add(((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value((Object)((PushTask)this.profile.getTask()).getResource().getKey())).build());
        this.update(patch);
        this.provision(any, enabled, result);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean handle(String anyKey) {
        Any any = null;
        try {
            any = this.getAnyUtils().dao().authFind(anyKey);
            Provision provision = ((PushTask)this.profile.getTask()).getResource().getProvision(any.getType()).orElse(null);
            if (provision == null) {
                throw new JobExecutionException("No provision found on " + ((PushTask)this.profile.getTask()).getResource() + " for " + any.getType().getKey());
            }
            this.doHandle(any, provision);
            return true;
        }
        catch (IgnoreProvisionException e) {
            ProvisioningReport ignoreResult = this.profile.getResults().stream().filter(report -> anyKey.equalsIgnoreCase(report.getKey())).findFirst().orElse(null);
            if (ignoreResult == null) {
                ignoreResult = new ProvisioningReport();
                ignoreResult.setKey(anyKey);
                ignoreResult.setAnyType(any == null ? null : any.getType().getKey());
                this.profile.getResults().add(ignoreResult);
            }
            ignoreResult.setOperation(ResourceOperation.NONE);
            ignoreResult.setStatus(ProvisioningReport.Status.IGNORE);
            ignoreResult.setMessage(e.getMessage());
            LOG.warn("Ignoring during push", (Throwable)e);
            return true;
        }
        catch (JobExecutionException e) {
            LOG.error("Push failed", (Throwable)e);
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doHandle(Any<?> any, Provision provision) throws JobExecutionException {
        HashMap<String, Object> jobMap;
        Boolean enable;
        ProvisioningReport result = new ProvisioningReport();
        this.profile.getResults().add(result);
        result.setKey(any.getKey());
        result.setAnyType(any.getType().getKey());
        result.setName(this.getName(any));
        LOG.debug("Propagating {} with key {} towards {}", new Object[]{any.getType().getKind(), any.getKey(), ((PushTask)this.profile.getTask()).getResource()});
        List<ConnectorObject> connObjs = this.pushUtils.match(this.profile.getConnector(), any, provision);
        LOG.debug("Match(es) found for {} as {}: {}", new Object[]{any, provision.getObjectClass(), connObjs});
        if (connObjs.size() > 1) {
            switch (this.profile.getConflictResolutionAction()) {
                case IGNORE: {
                    throw new IgnoreProvisionException("More than one match found for " + any.getKey() + ": " + connObjs);
                }
                case FIRSTMATCH: {
                    connObjs = connObjs.subList(0, 1);
                    break;
                }
                case LASTMATCH: {
                    connObjs = connObjs.subList(connObjs.size() - 1, connObjs.size());
                    break;
                }
            }
        }
        ConnectorObject beforeObj = connObjs.isEmpty() ? null : connObjs.get(0);
        Object output = null;
        AuditElements.Result resultStatus = null;
        Boolean bl = any instanceof User && ((PushTask)this.profile.getTask()).isSyncStatus() ? (((User)any).isSuspended().booleanValue() ? Boolean.FALSE : Boolean.TRUE) : (enable = null);
        if (this.profile.isDryRun()) {
            if (beforeObj == null) {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
            } else {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
            }
            result.setStatus(ProvisioningReport.Status.SUCCESS);
            return;
        }
        String operation = beforeObj == null ? UnmatchingRule.toEventName((UnmatchingRule)((PushTask)this.profile.getTask()).getUnmatchingRule()) : MatchingRule.toEventName((MatchingRule)((PushTask)this.profile.getTask()).getMatchingRule());
        boolean notificationsAvailable = this.notificationManager.notificationsAvailable(AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation);
        boolean auditRequested = this.auditManager.auditRequested(AuthContextUtils.getUsername(), AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation);
        try {
            if (beforeObj == null) {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getUnmatchingRule()));
                switch (((PushTask)this.profile.getTask()).getUnmatchingRule()) {
                    case ASSIGN: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeAssign(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            LOG.debug("PushTask not configured for create");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.assign(any, enable, result);
                        break;
                    }
                    case PROVISION: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeProvision(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformCreate()) {
                            LOG.debug("PushTask not configured for create");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.provision(any, enable, result);
                        break;
                    }
                    case UNLINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(any, true, result);
                        break;
                    }
                    case IGNORE: {
                        LOG.debug("Ignored any: {}", any);
                        result.setStatus(ProvisioningReport.Status.IGNORE);
                        break;
                    }
                }
            } else {
                result.setOperation(this.toResourceOperation(((PushTask)this.profile.getTask()).getMatchingRule()));
                switch (((PushTask)this.profile.getTask()).getMatchingRule()) {
                    case UPDATE: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUpdate(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.update(any, enable, beforeObj, result);
                        break;
                    }
                    case DEPROVISION: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeDeprovision(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            LOG.debug("PushTask not configured for delete");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.deprovision(any, beforeObj, result);
                        break;
                    }
                    case UNASSIGN: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnassign(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformDelete()) {
                            LOG.debug("PushTask not configured for delete");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.unassign(any, beforeObj, result);
                        break;
                    }
                    case LINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeLink(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(any, false, result);
                        break;
                    }
                    case UNLINK: {
                        for (PushActions action : this.profile.getActions()) {
                            action.beforeUnlink(this.profile, any);
                        }
                        if (!((PushTask)this.profile.getTask()).isPerformUpdate()) {
                            LOG.debug("PushTask not configured for update");
                            result.setStatus(ProvisioningReport.Status.IGNORE);
                            break;
                        }
                        this.link(any, true, result);
                        break;
                    }
                    case IGNORE: {
                        LOG.debug("Ignored any: {}", any);
                        result.setStatus(ProvisioningReport.Status.IGNORE);
                        break;
                    }
                }
            }
            for (PushActions action : this.profile.getActions()) {
                action.after(this.profile, any, result);
            }
            if (result.getStatus() == null) {
                result.setStatus(ProvisioningReport.Status.SUCCESS);
            }
            if (notificationsAvailable || auditRequested) {
                resultStatus = AuditElements.Result.SUCCESS;
                output = this.pushUtils.findByConnObjectKey(this.profile.getConnector(), any, provision);
            }
            if (!notificationsAvailable) {
                if (!auditRequested) return;
            }
            jobMap = new HashMap<String, Object>();
        }
        catch (IgnoreProvisionException e) {
            try {
                throw e;
                catch (Exception e2) {
                    result.setStatus(ProvisioningReport.Status.FAILURE);
                    result.setMessage(ExceptionUtils.getRootCauseMessage((Throwable)e2));
                    if (notificationsAvailable || auditRequested) {
                        resultStatus = AuditElements.Result.FAILURE;
                        output = e2;
                    }
                    LOG.warn("Error pushing {} towards {}", new Object[]{any, ((PushTask)this.profile.getTask()).getResource(), e2});
                    Iterator iterator = this.profile.getActions().iterator();
                    while (iterator.hasNext()) {
                        PushActions action = (PushActions)iterator.next();
                        action.onError(this.profile, any, result, e2);
                    }
                    throw new JobExecutionException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                if (!notificationsAvailable) {
                    if (!auditRequested) throw throwable;
                }
                HashMap<String, Object> jobMap2 = new HashMap<String, Object>();
                jobMap2.put("AfterHandlingEvent", new AfterHandlingEvent(AuthContextUtils.getUsername(), AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, output, new Object[]{any}));
                AfterHandlingJob.schedule(this.scheduler, jobMap2);
                throw throwable;
            }
        }
        jobMap.put("AfterHandlingEvent", new AfterHandlingEvent(AuthContextUtils.getUsername(), AuditElements.EventCategoryType.PUSH, any.getType().getKind().name().toLowerCase(), ((PushTask)this.profile.getTask()).getResource().getKey(), operation, resultStatus, (Object)beforeObj, output, new Object[]{any}));
        AfterHandlingJob.schedule(this.scheduler, jobMap);
    }

    protected ResourceOperation toResourceOperation(UnmatchingRule rule) {
        switch (rule) {
            case ASSIGN: 
            case PROVISION: {
                return ResourceOperation.CREATE;
            }
        }
        return ResourceOperation.NONE;
    }

    protected ResourceOperation toResourceOperation(MatchingRule rule) {
        switch (rule) {
            case UPDATE: {
                return ResourceOperation.UPDATE;
            }
            case DEPROVISION: 
            case UNASSIGN: {
                return ResourceOperation.DELETE;
            }
        }
        return ResourceOperation.NONE;
    }

    protected ProvisioningReport.Status toProvisioningReportStatus(ExecStatus status) {
        switch (status) {
            case FAILURE: {
                return ProvisioningReport.Status.FAILURE;
            }
            case SUCCESS: {
                return ProvisioningReport.Status.SUCCESS;
            }
        }
        return ProvisioningReport.Status.IGNORE;
    }
}

