/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.HashSet;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.entity.task.PropagationTask;
import org.apache.syncope.core.provisioning.api.propagation.PropagationActions;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class AzurePropagationActions
implements PropagationActions {
    private static final Logger LOG = LoggerFactory.getLogger(AzurePropagationActions.class);

    protected String getEmailAttrName() {
        return "mailNickname";
    }

    @Transactional
    public void before(PropagationTask task, ConnectorObject beforeObj) {
        if (task.getOperation() == ResourceOperation.DELETE || task.getOperation() == ResourceOperation.NONE) {
            return;
        }
        switch (task.getAnyTypeKind()) {
            case USER: {
                this.setName(task);
                break;
            }
            case GROUP: {
                this.setName(task);
                break;
            }
            default: {
                LOG.debug("Not about user or group: not doing anything");
            }
        }
    }

    private void setName(PropagationTask task) {
        HashSet<Name> attrs = new HashSet<Name>(task.getAttributes());
        if (AttributeUtil.find((String)this.getEmailAttrName(), attrs) == null) {
            LOG.warn("Can't find {} attribute to set as __NAME__ attribute value, skipping...", (Object)this.getEmailAttrName());
            return;
        }
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        if (name != null) {
            attrs.remove(name);
        }
        attrs.add(new Name(AttributeUtil.find((String)this.getEmailAttrName(), attrs).getValue().get(0).toString()));
        task.setAttributes(attrs);
    }
}

