/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.collections.IteratorChain;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ItemContainerTO;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.MappingTO;
import org.apache.syncope.common.lib.to.OrgUnitTO;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.to.ResourceHistoryConfTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceHistoryConfDAO;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PushPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResourceHistoryConf;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.Mapping;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnit;
import org.apache.syncope.core.persistence.api.entity.resource.OrgUnitItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.data.ResourceDataBinder;
import org.apache.syncope.core.provisioning.java.IntAttrNameParser;
import org.apache.syncope.core.provisioning.java.jexl.JexlUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourceDataBinderImpl
implements ResourceDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDataBinder.class);
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private PolicyDAO policyDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private AnyTypeClassDAO anyTypeClassDAO;
    @Autowired
    private ExternalResourceHistoryConfDAO resourceHistoryConfDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private IntAttrNameParser intAttrNameParser;

    public ExternalResource create(ResourceTO resourceTO) {
        return this.update((ExternalResource)this.entityFactory.newEntity(ExternalResource.class), resourceTO);
    }

    public ExternalResource update(ExternalResource resource, ResourceTO resourceTO) {
        ResourceTO current;
        if (resource.getKey() != null && !(current = this.getResourceTO(resource)).equals(resourceTO)) {
            ExternalResourceHistoryConf resourceHistoryConf = (ExternalResourceHistoryConf)this.entityFactory.newEntity(ExternalResourceHistoryConf.class);
            resourceHistoryConf.setCreator(AuthContextUtils.getUsername());
            resourceHistoryConf.setCreation(new Date());
            resourceHistoryConf.setEntity((Entity)resource);
            resourceHistoryConf.setConf((EntityTO)current);
            this.resourceHistoryConfDAO.save(resourceHistoryConf);
            List history = this.resourceHistoryConfDAO.findByEntity(resource);
            long maxHistorySize = (Long)this.confDAO.find("resource.conf.history.size", (Object)10L);
            if (maxHistorySize < (long)history.size()) {
                int i = 0;
                while ((long)i < (long)history.size() - maxHistorySize) {
                    this.resourceHistoryConfDAO.delete(((ExternalResourceHistoryConf)history.get(history.size() - 1)).getKey());
                    ++i;
                }
            }
        }
        resource.setKey(resourceTO.getKey());
        if (resourceTO.getConnector() != null) {
            ConnInstance connector = this.connInstanceDAO.find(resourceTO.getConnector());
            resource.setConnector(connector);
            if (!connector.getResources().contains(resource)) {
                connector.add(resource);
            }
        }
        resource.setEnforceMandatoryCondition(resourceTO.isEnforceMandatoryCondition());
        resource.setPropagationPriority(resourceTO.getPropagationPriority());
        resource.setRandomPwdIfNotProvided(resourceTO.isRandomPwdIfNotProvided());
        resourceTO.getProvisions().forEach(provisionTO -> {
            AnyType anyType = this.anyTypeDAO.find(provisionTO.getAnyType());
            if (anyType == null) {
                LOG.debug("Invalid {} specified {}, ignoring...", (Object)AnyType.class.getSimpleName(), (Object)provisionTO.getAnyType());
            } else {
                Provision provision = resource.getProvision(anyType).orElse(null);
                if (provision == null) {
                    provision = (Provision)this.entityFactory.newEntity(Provision.class);
                    provision.setResource(resource);
                    resource.add(provision);
                    provision.setAnyType(anyType);
                }
                if (provisionTO.getObjectClass() == null) {
                    SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidProvision);
                    sce.getElements().add("Null " + ObjectClass.class.getSimpleName());
                    throw sce;
                }
                provision.setObjectClass(new ObjectClass(provisionTO.getObjectClass()));
                for (String name : provisionTO.getAuxClasses()) {
                    AnyTypeClass anyTypeClass2 = this.anyTypeClassDAO.find(name);
                    if (anyTypeClass2 == null) {
                        LOG.warn("Ignoring invalid {}: {}", (Object)AnyTypeClass.class.getSimpleName(), (Object)name);
                        continue;
                    }
                    provision.add(anyTypeClass2);
                }
                provision.getAuxClasses().removeIf(anyTypeClass -> !provisionTO.getAuxClasses().contains(anyTypeClass.getKey()));
                provision.setIgnoreCaseMatch(provisionTO.isIgnoreCaseMatch());
                if (StringUtils.isNotBlank((CharSequence)provisionTO.getUidOnCreate())) {
                    PlainSchema uidOnCreate = (PlainSchema)this.plainSchemaDAO.find(provisionTO.getUidOnCreate());
                    if (uidOnCreate == null) {
                        LOG.warn("Ignoring invalid schema for uidOnCreate(): {}", (Object)provisionTO.getUidOnCreate());
                    } else {
                        provision.setUidOnCreate(uidOnCreate);
                    }
                }
                if (provisionTO.getMapping() == null) {
                    provision.setMapping(null);
                } else {
                    Mapping mapping = provision.getMapping();
                    if (mapping == null) {
                        mapping = (Mapping)this.entityFactory.newEntity(Mapping.class);
                        mapping.setProvision(provision);
                        provision.setMapping(mapping);
                    } else {
                        mapping.getItems().clear();
                    }
                    AnyTypeClassTO allowedSchemas = new AnyTypeClassTO();
                    IteratorChain itor = new IteratorChain(provision.getAnyType().getClasses().iterator(), provision.getAuxClasses().iterator());
                    while (itor.hasNext()) {
                        AnyTypeClass anyTypeClass3 = (AnyTypeClass)itor.next();
                        allowedSchemas.getPlainSchemas().addAll(anyTypeClass3.getPlainSchemas().stream().map(Entity::getKey).collect(Collectors.toList()));
                        allowedSchemas.getDerSchemas().addAll(anyTypeClass3.getDerSchemas().stream().map(Entity::getKey).collect(Collectors.toList()));
                        allowedSchemas.getVirSchemas().addAll(anyTypeClass3.getVirSchemas().stream().map(Entity::getKey).collect(Collectors.toList()));
                    }
                    this.populateMapping(provisionTO.getMapping(), mapping, allowedSchemas);
                }
                if (provisionTO.getVirSchemas().isEmpty()) {
                    for (VirSchema schema : this.virSchemaDAO.findByProvision(provision)) {
                        this.virSchemaDAO.delete(schema.getKey());
                    }
                } else {
                    for (String schemaName : provisionTO.getVirSchemas()) {
                        VirSchema schema = (VirSchema)this.virSchemaDAO.find(schemaName);
                        if (schema == null) {
                            LOG.debug("Invalid {} specified: {}, ignoring...", (Object)VirSchema.class.getSimpleName(), (Object)schemaName);
                            continue;
                        }
                        schema.setProvision(provision);
                    }
                }
            }
        });
        Iterator itor = resource.getProvisions().iterator();
        while (itor.hasNext()) {
            Provision provision = (Provision)itor.next();
            if (resourceTO.getProvision(provision.getAnyType().getKey()) != null) continue;
            this.virSchemaDAO.findByProvision(provision).forEach(schema -> this.virSchemaDAO.delete(schema.getKey()));
            itor.remove();
        }
        if (resourceTO.getOrgUnit() == null && resource.getOrgUnit() != null) {
            resource.getOrgUnit().setResource(null);
            resource.setOrgUnit(null);
        } else if (resourceTO.getOrgUnit() != null) {
            SyncopeClientException sce;
            OrgUnitTO orgUnitTO = resourceTO.getOrgUnit();
            OrgUnit orgUnit = resource.getOrgUnit();
            if (orgUnit == null) {
                orgUnit = (OrgUnit)this.entityFactory.newEntity(OrgUnit.class);
                orgUnit.setResource(resource);
                resource.setOrgUnit(orgUnit);
            }
            if (orgUnitTO.getObjectClass() == null) {
                sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidOrgUnit);
                sce.getElements().add("Null " + ObjectClass.class.getSimpleName());
                throw sce;
            }
            orgUnit.setObjectClass(new ObjectClass(orgUnitTO.getObjectClass()));
            orgUnit.setIgnoreCaseMatch(orgUnitTO.isIgnoreCaseMatch());
            if (orgUnitTO.getConnObjectLink() == null) {
                sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidOrgUnit);
                sce.getElements().add("Null connObjectLink");
                throw sce;
            }
            orgUnit.setConnObjectLink(orgUnitTO.getConnObjectLink());
            SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
            SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
            SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            orgUnit.getItems().clear();
            for (ItemTO itemTO : orgUnitTO.getItems()) {
                if (itemTO == null) {
                    LOG.error("Null {}", (Object)ItemTO.class.getSimpleName());
                    invalidMapping.getElements().add("Null " + ItemTO.class.getSimpleName());
                    continue;
                }
                if (itemTO.getIntAttrName() == null) {
                    requiredValuesMissing.getElements().add("intAttrName");
                    scce.addException(requiredValuesMissing);
                    continue;
                }
                if (!"name".equals(itemTO.getIntAttrName()) && !"fullpath".equals(itemTO.getIntAttrName())) {
                    LOG.error("Only 'name' and 'fullpath' are supported for Realms");
                    invalidMapping.getElements().add("Only 'name' and 'fullpath' are supported for Realms");
                    continue;
                }
                if (!JexlUtils.isExpressionValid(itemTO.getMandatoryCondition() == null ? "false" : itemTO.getMandatoryCondition())) {
                    SyncopeClientException invalidMandatoryCondition = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
                    invalidMandatoryCondition.getElements().add(itemTO.getMandatoryCondition());
                    scce.addException(invalidMandatoryCondition);
                }
                OrgUnitItem item = (OrgUnitItem)this.entityFactory.newEntity(OrgUnitItem.class);
                item.setIntAttrName(itemTO.getIntAttrName());
                item.setExtAttrName(itemTO.getExtAttrName());
                item.setPurpose(itemTO.getPurpose());
                item.setMandatoryCondition(itemTO.getMandatoryCondition());
                item.setConnObjectKey(itemTO.isConnObjectKey());
                item.setPassword(itemTO.isPassword());
                item.setPropagationJEXLTransformer(itemTO.getPropagationJEXLTransformer());
                item.setPullJEXLTransformer(itemTO.getPullJEXLTransformer());
                item.setOrgUnit(orgUnit);
                if (item.isConnObjectKey()) {
                    orgUnit.setConnObjectKeyItem(item);
                } else {
                    orgUnit.add(item);
                }
                itemTO.getTransformers().forEach(transformerKey -> {
                    Implementation transformer = this.implementationDAO.find(transformerKey);
                    if (transformer == null) {
                        LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", transformerKey);
                    } else {
                        item.add(transformer);
                    }
                });
                item.getTransformers().removeIf(implementation -> !itemTO.getTransformers().contains(implementation.getKey()));
            }
            if (!invalidMapping.getElements().isEmpty()) {
                scce.addException(invalidMapping);
            }
            if (scce.hasExceptions()) {
                throw scce;
            }
        }
        resource.setCreateTraceLevel(resourceTO.getCreateTraceLevel());
        resource.setUpdateTraceLevel(resourceTO.getUpdateTraceLevel());
        resource.setDeleteTraceLevel(resourceTO.getDeleteTraceLevel());
        resource.setProvisioningTraceLevel(resourceTO.getProvisioningTraceLevel());
        resource.setPasswordPolicy(resourceTO.getPasswordPolicy() == null ? null : (PasswordPolicy)this.policyDAO.find(resourceTO.getPasswordPolicy()));
        resource.setAccountPolicy(resourceTO.getAccountPolicy() == null ? null : (AccountPolicy)this.policyDAO.find(resourceTO.getAccountPolicy()));
        resource.setPullPolicy(resourceTO.getPullPolicy() == null ? null : (PullPolicy)this.policyDAO.find(resourceTO.getPullPolicy()));
        resource.setPushPolicy(resourceTO.getPushPolicy() == null ? null : (PushPolicy)this.policyDAO.find(resourceTO.getPushPolicy()));
        resource.setConfOverride(new HashSet(resourceTO.getConfOverride()));
        resource.setOverrideCapabilities(resourceTO.isOverrideCapabilities());
        resource.getCapabilitiesOverride().clear();
        resource.getCapabilitiesOverride().addAll(resourceTO.getCapabilitiesOverride());
        resourceTO.getPropagationActions().forEach(propagationActionKey -> {
            Implementation propagationAction = this.implementationDAO.find(propagationActionKey);
            if (propagationAction == null) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", propagationActionKey);
            } else {
                resource.add(propagationAction);
            }
        });
        resource.getPropagationActions().removeIf(implementation -> !resourceTO.getPropagationActions().contains(implementation.getKey()));
        return resource;
    }

    private void populateMapping(MappingTO mappingTO, Mapping mapping, AnyTypeClassTO allowedSchemas) {
        mapping.setConnObjectLink(mappingTO.getConnObjectLink());
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
        SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        for (ItemTO itemTO : mappingTO.getItems()) {
            if (itemTO == null) {
                LOG.error("Null {}", (Object)ItemTO.class.getSimpleName());
                invalidMapping.getElements().add("Null " + ItemTO.class.getSimpleName());
                continue;
            }
            if (itemTO.getIntAttrName() == null) {
                requiredValuesMissing.getElements().add("intAttrName");
                scce.addException(requiredValuesMissing);
                continue;
            }
            IntAttrName intAttrName = null;
            try {
                intAttrName = this.intAttrNameParser.parse(itemTO.getIntAttrName(), mapping.getProvision().getAnyType().getKind());
            }
            catch (ParseException e) {
                LOG.error("Invalid intAttrName '{}'", (Object)itemTO.getIntAttrName(), (Object)e);
            }
            if (intAttrName == null || intAttrName.getSchemaType() == null && intAttrName.getField() == null && intAttrName.getPrivilegesOfApplication() == null) {
                LOG.error("'{}' not existing", (Object)itemTO.getIntAttrName());
                invalidMapping.getElements().add("'" + itemTO.getIntAttrName() + "' not existing");
                continue;
            }
            boolean allowed = true;
            if (intAttrName.getSchemaType() != null && intAttrName.getEnclosingGroup() == null && intAttrName.getRelatedAnyObject() == null && intAttrName.getPrivilegesOfApplication() == null) {
                switch (intAttrName.getSchemaType()) {
                    case PLAIN: {
                        allowed = allowedSchemas.getPlainSchemas().contains(intAttrName.getSchemaName());
                        break;
                    }
                    case DERIVED: {
                        allowed = allowedSchemas.getDerSchemas().contains(intAttrName.getSchemaName());
                        break;
                    }
                    case VIRTUAL: {
                        allowed = allowedSchemas.getVirSchemas().contains(intAttrName.getSchemaName());
                        break;
                    }
                }
            }
            if (allowed) {
                if (!JexlUtils.isExpressionValid(itemTO.getMandatoryCondition() == null ? "false" : itemTO.getMandatoryCondition())) {
                    SyncopeClientException invalidMandatoryCondition = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
                    invalidMandatoryCondition.getElements().add(itemTO.getMandatoryCondition());
                    scce.addException(invalidMandatoryCondition);
                }
                MappingItem item = (MappingItem)this.entityFactory.newEntity(MappingItem.class);
                item.setIntAttrName(itemTO.getIntAttrName());
                item.setExtAttrName(itemTO.getExtAttrName());
                item.setPurpose(itemTO.getPurpose());
                item.setMandatoryCondition(itemTO.getMandatoryCondition());
                item.setConnObjectKey(itemTO.isConnObjectKey());
                item.setPassword(itemTO.isPassword());
                item.setPropagationJEXLTransformer(itemTO.getPropagationJEXLTransformer());
                item.setPullJEXLTransformer(itemTO.getPullJEXLTransformer());
                item.setMapping(mapping);
                if (item.isConnObjectKey()) {
                    if (intAttrName.getSchemaType() == SchemaType.VIRTUAL) {
                        invalidMapping.getElements().add("Virtual attributes cannot be set as ConnObjectKey");
                    }
                    if ("password".equals(intAttrName.getField())) {
                        invalidMapping.getElements().add("Password attributes cannot be set as ConnObjectKey");
                    }
                    mapping.setConnObjectKeyItem(item);
                } else {
                    mapping.add(item);
                }
                itemTO.getTransformers().forEach(transformerKey -> {
                    Implementation transformer = this.implementationDAO.find(transformerKey);
                    if (transformer == null) {
                        LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", transformerKey);
                    } else {
                        item.add(transformer);
                    }
                });
                item.getTransformers().removeIf(implementation -> !itemTO.getTransformers().contains(implementation.getKey()));
                if (intAttrName.getEnclosingGroup() != null && item.getPurpose() != MappingPurpose.PROPAGATION) {
                    invalidMapping.getElements().add("Only " + MappingPurpose.PROPAGATION.name() + " allowed when referring to groups");
                }
                if (intAttrName.getRelatedAnyObject() != null && item.getPurpose() != MappingPurpose.PROPAGATION) {
                    invalidMapping.getElements().add("Only " + MappingPurpose.PROPAGATION.name() + " allowed when referring to any objects");
                }
                if (intAttrName.getPrivilegesOfApplication() != null && item.getPurpose() != MappingPurpose.PROPAGATION) {
                    invalidMapping.getElements().add("Only " + MappingPurpose.PROPAGATION.name() + " allowed when referring to privileges");
                }
                if (intAttrName.getSchemaType() == SchemaType.DERIVED && item.getPurpose() != MappingPurpose.PROPAGATION) {
                    invalidMapping.getElements().add("Only " + MappingPurpose.PROPAGATION.name() + " allowed for derived");
                }
                if (intAttrName.getSchemaType() == SchemaType.VIRTUAL) {
                    VirSchema schema;
                    if (item.getPurpose() != MappingPurpose.PROPAGATION) {
                        invalidMapping.getElements().add("Only " + MappingPurpose.PROPAGATION.name() + " allowed for virtual");
                    }
                    if ((schema = (VirSchema)this.virSchemaDAO.find(item.getIntAttrName())) != null && schema.getProvision().equals(item.getMapping().getProvision())) {
                        invalidMapping.getElements().add("No need to map virtual schema on linking resource");
                    }
                }
                if (intAttrName.getRelatedUser() != null && item.getPurpose() != MappingPurpose.PROPAGATION) {
                    invalidMapping.getElements().add("Only " + MappingPurpose.PROPAGATION.name() + " allowed when referring to users");
                }
                if (intAttrName.getRelationshipType() == null && intAttrName.getRelationshipAnyType() == null || item.getPurpose() == MappingPurpose.PROPAGATION) continue;
                invalidMapping.getElements().add("Only " + MappingPurpose.PROPAGATION.name() + " allowed when referring to relationships");
                continue;
            }
            LOG.error("'{}' not allowed", (Object)itemTO.getIntAttrName());
            invalidMapping.getElements().add("'" + itemTO.getIntAttrName() + "' not allowed");
        }
        if (!invalidMapping.getElements().isEmpty()) {
            scce.addException(invalidMapping);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    private void populateItems(List<? extends Item> items, ItemContainerTO containerTO) {
        items.forEach(item -> {
            ItemTO itemTO = new ItemTO();
            itemTO.setKey(item.getKey());
            itemTO.setIntAttrName(item.getIntAttrName());
            itemTO.setExtAttrName(item.getExtAttrName());
            itemTO.setPurpose(item.getPurpose());
            itemTO.setMandatoryCondition(item.getMandatoryCondition());
            itemTO.setConnObjectKey(item.isConnObjectKey());
            itemTO.setPassword(item.isPassword());
            itemTO.setPropagationJEXLTransformer(item.getPropagationJEXLTransformer());
            itemTO.setPullJEXLTransformer(item.getPullJEXLTransformer());
            if (itemTO.isConnObjectKey()) {
                containerTO.setConnObjectKeyItem(itemTO);
            } else {
                containerTO.add(itemTO);
            }
            itemTO.getTransformers().addAll(item.getTransformers().stream().map(Entity::getKey).collect(Collectors.toSet()));
        });
    }

    public ResourceTO getResourceTO(ExternalResource resource) {
        ResourceTO resourceTO = new ResourceTO();
        resourceTO.setKey(resource.getKey());
        ConnInstance connector = resource.getConnector();
        resourceTO.setConnector(connector == null ? null : connector.getKey());
        resourceTO.setConnectorDisplayName(connector == null ? null : connector.getDisplayName());
        resource.getProvisions().forEach(provision -> {
            ProvisionTO provisionTO = new ProvisionTO();
            provisionTO.setKey(provision.getKey());
            provisionTO.setAnyType(provision.getAnyType().getKey());
            provisionTO.setObjectClass(provision.getObjectClass().getObjectClassValue());
            provisionTO.getAuxClasses().addAll(provision.getAuxClasses().stream().map(Entity::getKey).collect(Collectors.toList()));
            provisionTO.setSyncToken(provision.getSerializedSyncToken());
            provisionTO.setIgnoreCaseMatch(provision.isIgnoreCaseMatch());
            if (provision.getUidOnCreate() != null) {
                provisionTO.setUidOnCreate(provision.getUidOnCreate().getKey());
            }
            if (provision.getMapping() != null) {
                MappingTO mappingTO = new MappingTO();
                provisionTO.setMapping(mappingTO);
                mappingTO.setConnObjectLink(provision.getMapping().getConnObjectLink());
                this.populateItems(provision.getMapping().getItems(), (ItemContainerTO)mappingTO);
            }
            this.virSchemaDAO.findByProvision(provision).forEach(virSchema -> {
                provisionTO.getVirSchemas().add(virSchema.getKey());
                MappingItem linkingMappingItem = virSchema.asLinkingMappingItem();
                ItemTO itemTO = new ItemTO();
                itemTO.setKey(linkingMappingItem.getKey());
                itemTO.setIntAttrName(linkingMappingItem.getIntAttrName());
                itemTO.setExtAttrName(linkingMappingItem.getExtAttrName());
                itemTO.setPurpose(linkingMappingItem.getPurpose());
                itemTO.setMandatoryCondition(linkingMappingItem.getMandatoryCondition());
                itemTO.setConnObjectKey(linkingMappingItem.isConnObjectKey());
                itemTO.setPassword(linkingMappingItem.isPassword());
                itemTO.setPropagationJEXLTransformer(linkingMappingItem.getPropagationJEXLTransformer());
                itemTO.setPullJEXLTransformer(linkingMappingItem.getPullJEXLTransformer());
                provisionTO.getMapping().getLinkingItems().add(itemTO);
            });
            resourceTO.getProvisions().add(provisionTO);
        });
        if (resource.getOrgUnit() != null) {
            OrgUnit orgUnit = resource.getOrgUnit();
            OrgUnitTO orgUnitTO = new OrgUnitTO();
            orgUnitTO.setKey(orgUnit.getKey());
            orgUnitTO.setObjectClass(orgUnit.getObjectClass().getObjectClassValue());
            orgUnitTO.setSyncToken(orgUnit.getSerializedSyncToken());
            orgUnitTO.setIgnoreCaseMatch(orgUnit.isIgnoreCaseMatch());
            orgUnitTO.setConnObjectLink(orgUnit.getConnObjectLink());
            this.populateItems(orgUnit.getItems(), (ItemContainerTO)orgUnitTO);
            resourceTO.setOrgUnit(orgUnitTO);
        }
        resourceTO.setEnforceMandatoryCondition(resource.isEnforceMandatoryCondition());
        resourceTO.setPropagationPriority(resource.getPropagationPriority());
        resourceTO.setRandomPwdIfNotProvided(resource.isRandomPwdIfNotProvided());
        resourceTO.setCreateTraceLevel(resource.getCreateTraceLevel());
        resourceTO.setUpdateTraceLevel(resource.getUpdateTraceLevel());
        resourceTO.setDeleteTraceLevel(resource.getDeleteTraceLevel());
        resourceTO.setProvisioningTraceLevel(resource.getProvisioningTraceLevel());
        resourceTO.setPasswordPolicy(resource.getPasswordPolicy() == null ? null : resource.getPasswordPolicy().getKey());
        resourceTO.setAccountPolicy(resource.getAccountPolicy() == null ? null : resource.getAccountPolicy().getKey());
        resourceTO.setPullPolicy(resource.getPullPolicy() == null ? null : resource.getPullPolicy().getKey());
        resourceTO.setPushPolicy(resource.getPushPolicy() == null ? null : resource.getPushPolicy().getKey());
        resourceTO.getConfOverride().addAll(resource.getConfOverride());
        Collections.sort(resourceTO.getConfOverride());
        resourceTO.setOverrideCapabilities(resource.isOverrideCapabilities());
        resourceTO.getCapabilitiesOverride().addAll(resource.getCapabilitiesOverride());
        resourceTO.getPropagationActions().addAll(resource.getPropagationActions().stream().map(Entity::getKey).collect(Collectors.toList()));
        return resourceTO;
    }

    public ResourceHistoryConfTO getResourceHistoryConfTO(ExternalResourceHistoryConf history) {
        ResourceHistoryConfTO historyTO = new ResourceHistoryConfTO();
        historyTO.setKey(history.getKey());
        historyTO.setCreator(history.getCreator());
        historyTO.setCreation(history.getCreation());
        historyTO.setResourceTO((ResourceTO)history.getConf());
        return historyTO;
    }
}

