/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttr;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.conf.CPlainAttrValue;
import org.apache.syncope.core.provisioning.api.data.ConfigurationDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.apache.syncope.core.provisioning.java.jexl.JexlUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationDataBinderImpl
extends AbstractAnyDataBinder
implements ConfigurationDataBinder {
    @Autowired
    private ConfDAO confDAO;

    public List<AttrTO> getConfTO() {
        return this.confDAO.get().getPlainAttrs().stream().map(attr -> this.getAttrTO((CPlainAttr)attr)).collect(Collectors.toList());
    }

    public AttrTO getAttrTO(CPlainAttr attr) {
        return new AttrTO.Builder().schema(attr.getSchema().getKey()).values((Collection)attr.getValuesAsStrings()).build();
    }

    private void fillAttr(List<String> values, PlainSchema schema, CPlainAttr attr, SyncopeClientException invalidValues) {
        List<String> valuesProvided;
        List<String> list = schema.isMultivalue() ? values : (valuesProvided = values.isEmpty() ? Collections.emptyList() : Collections.singletonList(values.iterator().next()));
        if (valuesProvided.isEmpty()) {
            MapContext jexlContext = new MapContext();
            JexlUtils.addPlainAttrsToContext(this.confDAO.get().getPlainAttrs(), (JexlContext)jexlContext);
            if (!schema.isReadonly() && Boolean.parseBoolean(JexlUtils.evaluate(schema.getMandatoryCondition(), (JexlContext)jexlContext))) {
                LOG.error("Mandatory schema " + schema.getKey() + " not provided with values");
                SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
                reqValMissing.getElements().add(schema.getKey());
                throw reqValMissing;
            }
        }
        valuesProvided.forEach(value -> {
            if (value == null || value.isEmpty()) {
                LOG.debug("Null value for {}, ignoring", (Object)schema.getKey());
            } else {
                try {
                    PlainAttrValue attrValue;
                    if (schema.isUniqueConstraint()) {
                        attrValue = (PlainAttrValue)this.entityFactory.newEntity(CPlainAttrUniqueValue.class);
                        ((PlainAttrUniqueValue)attrValue).setSchema(schema);
                    } else {
                        attrValue = (PlainAttrValue)this.entityFactory.newEntity(CPlainAttrValue.class);
                    }
                    attr.add(value, attrValue);
                }
                catch (InvalidPlainAttrValueException e) {
                    LOG.warn("Invalid value for attribute " + schema.getKey() + ": " + value, (Throwable)e);
                    invalidValues.getElements().add(schema.getKey() + ": " + value + " - " + e.getMessage());
                }
            }
        });
    }

    public CPlainAttr getAttr(AttrTO attrTO) {
        PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
        if (schema == null) {
            throw new NotFoundException("Conf schema " + attrTO.getSchema());
        }
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        CPlainAttr attr = (CPlainAttr)this.entityFactory.newEntity(CPlainAttr.class);
        attr.setSchema(schema);
        this.fillAttr(attrTO.getValues(), schema, attr, invalidValues);
        if (!invalidValues.isEmpty()) {
            throw invalidValues;
        }
        return attr;
    }
}

