/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.APlainAttr;
import org.apache.syncope.core.persistence.api.entity.anyobject.ARelationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class AnyObjectDataBinderImpl
extends AbstractAnyDataBinder
implements AnyObjectDataBinder {
    @Autowired
    private AnyTypeDAO anyTypeDAO;

    @Transactional(readOnly=true)
    public AnyObjectTO getAnyObjectTO(String key) {
        return this.getAnyObjectTO((AnyObject)this.anyObjectDAO.authFind(key), true);
    }

    public AnyObjectTO getAnyObjectTO(AnyObject anyObject, boolean details) {
        AnyObjectTO anyObjectTO = new AnyObjectTO();
        anyObjectTO.setKey(anyObject.getKey());
        anyObjectTO.setName(anyObject.getName());
        anyObjectTO.setType(anyObject.getType().getKey());
        anyObjectTO.setCreationDate(anyObject.getCreationDate());
        anyObjectTO.setCreator(anyObject.getCreator());
        anyObjectTO.setLastChangeDate(anyObject.getLastChangeDate());
        anyObjectTO.setLastModifier(anyObject.getLastModifier());
        anyObjectTO.setStatus(anyObject.getStatus());
        Map virAttrValues = details ? this.virAttrHandler.getValues((Any)anyObject) : Collections.emptyMap();
        this.fillTO((AnyTO)anyObjectTO, anyObject.getRealm().getFullPath(), anyObject.getAuxClasses(), anyObject.getPlainAttrs(), this.derAttrHandler.getValues((Any)anyObject), virAttrValues, this.anyObjectDAO.findAllResources(anyObject), details);
        if (details) {
            anyObjectTO.getDynRealms().addAll(this.userDAO.findDynRealms(anyObject.getKey()));
            anyObjectTO.getRelationships().addAll(this.anyObjectDAO.findAllRelationships(anyObject).stream().map(relationship -> this.getRelationshipTO(relationship.getType().getKey(), relationship.getLeftEnd().getKey().equals(anyObject.getKey()) ? (AnyObject)relationship.getRightEnd() : anyObject)).collect(Collectors.toList()));
            anyObjectTO.getMemberships().addAll(anyObject.getMemberships().stream().map(membership -> this.getMembershipTO(anyObject.getPlainAttrs((Membership)membership), this.derAttrHandler.getValues((GroupableRelatable)anyObject, (Membership)membership), this.virAttrHandler.getValues((Any)anyObject, (Membership)membership), (Membership<? extends Any<?>>)membership)).collect(Collectors.toList()));
            anyObjectTO.getDynMemberships().addAll(this.anyObjectDAO.findDynGroups(anyObject.getKey()).stream().map(group -> new MembershipTO.Builder().group(group.getKey(), group.getName()).build()).collect(Collectors.toList()));
        }
        return anyObjectTO;
    }

    public void create(AnyObject anyObject, AnyObjectTO anyObjectTO) {
        AnyType type = this.anyTypeDAO.find(anyObjectTO.getType());
        if (type == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(anyObjectTO.getType());
            throw sce;
        }
        anyObject.setType(type);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidGroups = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidGroup);
        if (anyObjectTO.getName() == null) {
            LOG.error("No name specified for this anyObject");
            invalidGroups.getElements().add("No name specified for this anyObject");
        } else {
            anyObject.setName(anyObjectTO.getName());
        }
        Realm realm = this.realmDAO.findByFullPath(anyObjectTO.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + anyObjectTO.getRealm());
            scce.addException(noRealm);
        }
        anyObject.setRealm(realm);
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT);
        if (anyObject.getRealm() != null) {
            anyObjectTO.getRelationships().forEach(relationshipTO -> {
                if (StringUtils.isBlank((CharSequence)relationshipTO.getOtherEndType()) || AnyTypeKind.USER.name().equals(relationshipTO.getOtherEndType()) || AnyTypeKind.GROUP.name().equals(relationshipTO.getOtherEndType())) {
                    SyncopeClientException invalidAnyType = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
                    invalidAnyType.getElements().add(AnyType.class.getSimpleName() + " not allowed for relationship: " + relationshipTO.getOtherEndType());
                    scce.addException(invalidAnyType);
                } else {
                    AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(relationshipTO.getOtherEndKey());
                    if (otherEnd == null) {
                        LOG.debug("Ignoring invalid anyObject " + relationshipTO.getOtherEndKey());
                    } else if (anyObject.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                        RelationshipType relationshipType = this.relationshipTypeDAO.find(relationshipTO.getType());
                        if (relationshipType == null) {
                            LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType());
                        } else {
                            ARelationship relationship = (ARelationship)this.entityFactory.newEntity(ARelationship.class);
                            relationship.setType(relationshipType);
                            relationship.setRightEnd((Any)otherEnd);
                            relationship.setLeftEnd((Any)anyObject);
                            anyObject.add((Relationship)relationship);
                        }
                    } else {
                        LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)anyObject);
                        SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                        unassignabled.getElements().add("Cannot be assigned: " + otherEnd);
                        scce.addException(unassignabled);
                    }
                }
            });
            anyObjectTO.getMemberships().forEach(membershipTO -> {
                Group group;
                Group group2 = group = membershipTO.getGroupKey() == null ? this.groupDAO.findByName(membershipTO.getGroupName()) : (Group)this.groupDAO.find(membershipTO.getGroupKey());
                if (group == null) {
                    LOG.debug("Ignoring invalid group " + membershipTO.getGroupKey() + " / " + membershipTO.getGroupName());
                } else if (anyObject.getRealm().getFullPath().startsWith(group.getRealm().getFullPath())) {
                    AMembership membership = (AMembership)this.entityFactory.newEntity(AMembership.class);
                    membership.setRightEnd((Any)group);
                    membership.setLeftEnd((Any)anyObject);
                    anyObject.add((Membership)membership);
                    this.fill((Any)anyObject, (Membership)membership, (MembershipTO)membershipTO, anyUtils, scce);
                } else {
                    LOG.error("{} cannot be assigned to {}", (Object)group, (Object)anyObject);
                    SyncopeClientException unassignable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                    unassignable.getElements().add("Cannot be assigned: " + group);
                    scce.addException(unassignable);
                }
            });
        }
        this.fill((Any)anyObject, (AnyTO)anyObjectTO, anyUtils, scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public PropagationByResource update(AnyObject toBeUpdated, AnyObjectPatch anyObjectPatch) {
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.save((Any)toBeUpdated);
        PropagationByResource propByRes = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT);
        Collection currentResources = this.anyObjectDAO.findAllResourceKeys(anyObject.getKey());
        Map<String, String> oldConnObjectKeys = this.getConnObjectKeys((Any<?>)anyObject, anyUtils);
        this.setRealm((Any<?>)anyObject, (AnyPatch)anyObjectPatch);
        if (anyObjectPatch.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)anyObjectPatch.getName().getValue()))) {
            propByRes.addAll(ResourceOperation.UPDATE, this.anyObjectDAO.findAllResourceKeys(anyObject.getKey()));
            anyObject.setName((String)anyObjectPatch.getName().getValue());
        }
        propByRes.merge(this.fill((Any)anyObject, (AnyPatch)anyObjectPatch, anyUtils, scce));
        anyObjectPatch.getRelationships().stream().filter(patch -> patch.getRelationshipTO() != null).forEachOrdered(patch -> {
            RelationshipType relationshipType = this.relationshipTypeDAO.find(patch.getRelationshipTO().getType());
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch.getRelationshipTO().getType());
            } else {
                anyObject.getRelationship(relationshipType, patch.getRelationshipTO().getOtherEndKey()).ifPresent(relationship -> {
                    anyObject.getRelationships().remove(relationship);
                    relationship.setLeftEnd(null);
                });
                if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                    if (StringUtils.isBlank((CharSequence)patch.getRelationshipTO().getOtherEndType()) || AnyTypeKind.USER.name().equals(patch.getRelationshipTO().getOtherEndType()) || AnyTypeKind.GROUP.name().equals(patch.getRelationshipTO().getOtherEndType())) {
                        SyncopeClientException invalidAnyType = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
                        invalidAnyType.getElements().add(AnyType.class.getSimpleName() + " not allowed for relationship: " + patch.getRelationshipTO().getOtherEndType());
                        scce.addException(invalidAnyType);
                    } else {
                        AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(patch.getRelationshipTO().getOtherEndKey());
                        if (otherEnd == null) {
                            LOG.debug("Ignoring invalid any object {}", (Object)patch.getRelationshipTO().getOtherEndKey());
                        } else if (anyObject.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                            ARelationship newRelationship = (ARelationship)this.entityFactory.newEntity(ARelationship.class);
                            newRelationship.setType(relationshipType);
                            newRelationship.setRightEnd((Any)otherEnd);
                            newRelationship.setLeftEnd((Any)anyObject);
                            anyObject.add((Relationship)newRelationship);
                        } else {
                            LOG.error("{} cannot be assigned to {}", (Object)otherEnd, (Object)anyObject);
                            SyncopeClientException unassignable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                            unassignable.getElements().add("Cannot be assigned: " + otherEnd);
                            scce.addException(unassignable);
                        }
                    }
                }
            }
        });
        Collection resources = this.anyObjectDAO.findAllResources(anyObject);
        HashMap reasons = new HashMap();
        anyObject.getResources().forEach(resource -> reasons.put(resource.getKey(), new HashSet<String>(Collections.singleton(anyObject.getKey()))));
        this.anyObjectDAO.findAllGroupKeys(anyObject).forEach(group -> this.groupDAO.findAllResourceKeys(group).forEach(resource -> {
            if (!reasons.containsKey(resource)) {
                reasons.put(resource, new HashSet());
            }
            ((Set)reasons.get(resource)).add(group);
        }));
        HashSet toBeDeprovisioned = new HashSet();
        HashSet toBeProvisioned = new HashSet();
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        anyObjectPatch.getMemberships().stream().filter(membPatch -> membPatch.getGroup() != null).forEachOrdered(membPatch -> {
            anyObject.getMembership(membPatch.getGroup()).ifPresent(membership -> {
                anyObject.remove((Membership)membership);
                membership.setLeftEnd(null);
                anyObject.getPlainAttrs((Membership)membership).forEach(attr -> {
                    anyObject.remove((GroupablePlainAttr)attr);
                    attr.setOwner(null);
                    attr.setMembership(null);
                    this.plainAttrValueDAO.deleteAll((PlainAttr)attr, anyUtils);
                });
                if (membPatch.getOperation() == PatchOperation.DELETE) {
                    this.groupDAO.findAllResourceKeys(((Group)membership.getRightEnd()).getKey()).stream().filter(resource -> reasons.containsKey(resource)).forEach(resource -> {
                        ((Set)reasons.get(resource)).remove(((Group)membership.getRightEnd()).getKey());
                        toBeProvisioned.add(resource);
                    });
                }
            });
            if (membPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                Group group = (Group)this.groupDAO.find(membPatch.getGroup());
                if (group == null) {
                    LOG.debug("Ignoring invalid group {}", (Object)membPatch.getGroup());
                } else if (anyObject.getRealm().getFullPath().startsWith(group.getRealm().getFullPath())) {
                    AMembership newMembership = (AMembership)this.entityFactory.newEntity(AMembership.class);
                    newMembership.setRightEnd((Any)group);
                    newMembership.setLeftEnd((Any)anyObject);
                    anyObject.add((Membership)newMembership);
                    membPatch.getPlainAttrs().forEach(attrTO -> {
                        PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
                        if (schema == null) {
                            LOG.debug("Invalid " + PlainSchema.class.getSimpleName() + "{}, ignoring...", (Object)attrTO.getSchema());
                        } else {
                            Optional attr = anyObject.getPlainAttr(schema.getKey(), (Membership)newMembership);
                            if (!attr.isPresent()) {
                                LOG.debug("No plain attribute found for {} and membership of {}", (Object)schema, (Object)newMembership.getRightEnd());
                                APlainAttr newAttr = (APlainAttr)anyUtils.newPlainAttr();
                                newAttr.setOwner((Any)anyObject);
                                newAttr.setMembership((Membership)newMembership);
                                newAttr.setSchema(schema);
                                anyObject.add((GroupablePlainAttr)newAttr);
                                AttrPatch patch = (AttrPatch)new AttrPatch.Builder().attrTO(attrTO).build();
                                this.processAttrPatch((Any)anyObject, patch, schema, (PlainAttr<?>)newAttr, anyUtils, resources, propByRes, invalidValues);
                            }
                        }
                    });
                    if (!invalidValues.isEmpty()) {
                        scce.addException(invalidValues);
                    }
                    toBeProvisioned.addAll(this.groupDAO.findAllResourceKeys(group.getKey()));
                } else {
                    LOG.error("{} cannot be assigned to {}", (Object)group, (Object)anyObject);
                    SyncopeClientException unassignabled = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                    unassignabled.getElements().add("Cannot be assigned: " + group);
                    scce.addException(unassignabled);
                }
            }
        });
        reasons.entrySet().stream().filter(entry -> ((Set)entry.getValue()).isEmpty()).forEach(entry -> toBeDeprovisioned.add(entry.getKey()));
        propByRes.addAll(ResourceOperation.DELETE, toBeDeprovisioned);
        propByRes.addAll(ResourceOperation.UPDATE, toBeProvisioned);
        if (!toBeDeprovisioned.isEmpty() || !toBeProvisioned.isEmpty()) {
            currentResources.removeAll(toBeDeprovisioned);
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        Map<String, String> newConnObjectKeys = this.getConnObjectKeys((Any<?>)anyObject, anyUtils);
        oldConnObjectKeys.entrySet().stream().filter(entry -> newConnObjectKeys.containsKey(entry.getKey()) && !((String)entry.getValue()).equals(newConnObjectKeys.get(entry.getKey()))).forEach(entry -> {
            propByRes.addOldConnObjectKey((String)entry.getKey(), (String)entry.getValue());
            propByRes.add(ResourceOperation.UPDATE, (String)entry.getKey());
        });
        Pair dynGroupMembs = this.anyObjectDAO.saveAndGetDynGroupMembs(anyObject);
        ((Set)dynGroupMembs.getLeft()).stream().filter(group -> !((Set)dynGroupMembs.getRight()).contains(group)).forEach(delete -> ((Group)this.groupDAO.find(delete)).getResources().stream().filter(resource -> !propByRes.contains(resource.getKey())).forEach(resource -> propByRes.add(ResourceOperation.DELETE, resource.getKey())));
        ((Set)dynGroupMembs.getLeft()).stream().filter(group -> ((Set)dynGroupMembs.getRight()).contains(group)).forEach(update -> ((Group)this.groupDAO.find(update)).getResources().stream().filter(resource -> !propByRes.contains(resource.getKey())).forEach(resource -> propByRes.add(ResourceOperation.UPDATE, resource.getKey())));
        ((Set)dynGroupMembs.getRight()).stream().filter(group -> !((Set)dynGroupMembs.getLeft()).contains(group)).forEach(create -> ((Group)this.groupDAO.find(create)).getResources().stream().filter(resource -> !propByRes.contains(resource.getKey())).forEach(resource -> propByRes.add(ResourceOperation.CREATE, resource.getKey())));
        if (scce.hasExceptions()) {
            throw scce;
        }
        this.anyObjectDAO.save((Any)anyObject);
        return propByRes;
    }
}

