/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCacheValue;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Component
public class VirAttrHandlerImpl
implements VirAttrHandler {
    private static final Logger LOG = LoggerFactory.getLogger(VirAttrHandler.class);
    @Autowired
    private ConnectorFactory connFactory;
    @Autowired
    private VirAttrCache virAttrCache;
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    private Map<VirSchema, List<String>> getValues(Any<?> any, Set<VirSchema> schemas) {
        Set ownedResources = this.anyUtilsFactory.getInstance(any).getAllResources(any);
        HashMap<VirSchema, List<String>> result = new HashMap<VirSchema, List<String>>();
        HashMap<Provision, Set> toRead = new HashMap<Provision, Set>();
        schemas.forEach(schema -> {
            if (ownedResources.contains(schema.getProvision().getResource())) {
                VirAttrCacheValue virAttrCacheValue = this.virAttrCache.get(any.getType().getKey(), any.getKey(), schema.getKey());
                if (this.virAttrCache.isValidEntry(virAttrCacheValue)) {
                    LOG.debug("Values for {} found in cache: {}", schema, (Object)virAttrCacheValue);
                    result.put((VirSchema)schema, virAttrCacheValue.getValues());
                } else if (schema.getProvision().getAnyType().equals(any.getType())) {
                    HashSet<VirSchema> schemasToRead = (HashSet<VirSchema>)toRead.get(schema.getProvision());
                    if (schemasToRead == null) {
                        schemasToRead = new HashSet<VirSchema>();
                        toRead.put(schema.getProvision(), schemasToRead);
                    }
                    schemasToRead.add((VirSchema)schema);
                }
            } else {
                LOG.debug("Not considering {} since {} is not assigned to {}", new Object[]{schema, any, schema.getProvision().getResource()});
            }
        });
        toRead.forEach((provision, schemasToRead) -> {
            String connObjectKeyValue;
            LOG.debug("About to read from {}: {}", provision, schemasToRead);
            Optional<? extends MappingItem> connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision);
            String string = connObjectKeyValue = connObjectKeyItem.isPresent() ? (String)this.mappingManager.getConnObjectKeyValue(any, provision).orElse(null) : null;
            if (!connObjectKeyItem.isPresent() || connObjectKeyValue == null) {
                LOG.error("No ConnObjectKey or value found for {}, ignoring...", provision);
            } else {
                HashSet<MappingItem> linkingMappingItems = new HashSet<MappingItem>();
                linkingMappingItems.add(connObjectKeyItem.get());
                linkingMappingItems.addAll(schemasToRead.stream().map(schema -> schema.asLinkingMappingItem()).collect(Collectors.toSet()));
                Connector connector = this.connFactory.getConnector(provision.getResource());
                try {
                    ConnectorObject connectorObject = connector.getObject(provision.getObjectClass(), AttributeBuilder.build((String)connObjectKeyItem.get().getExtAttrName(), (Object[])new Object[]{connObjectKeyValue}), provision.isIgnoreCaseMatch(), MappingUtils.buildOperationOptions(linkingMappingItems.iterator()));
                    if (connectorObject == null) {
                        LOG.debug("No read from {} with filter '{} == {}'", new Object[]{provision, connObjectKeyItem.get().getExtAttrName(), connObjectKeyValue});
                    } else {
                        schemasToRead.forEach(schema -> {
                            Attribute attr = connectorObject.getAttributeByName(schema.getExtAttrName());
                            if (attr != null) {
                                VirAttrCacheValue virAttrCacheValue = new VirAttrCacheValue();
                                virAttrCacheValue.setValues((Collection)attr.getValue());
                                this.virAttrCache.put(any.getType().getKey(), any.getKey(), schema.getKey(), virAttrCacheValue);
                                LOG.debug("Values for {} set in cache: {}", schema, (Object)virAttrCacheValue);
                                result.put((VirSchema)schema, virAttrCacheValue.getValues());
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LOG.error("Error reading from {}", provision, (Object)e);
                }
            }
        });
        return result;
    }

    public List<String> getValues(Any<?> any, VirSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).forSelfContains((Schema)schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return Collections.emptyList();
        }
        List<String> result = this.getValues(any, Collections.singleton(schema)).get(schema);
        return result == null ? Collections.emptyList() : result;
    }

    public List<String> getValues(Any<?> any, Membership<?> membership, VirSchema schema) {
        if (!this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForMembership((Group)membership.getRightEnd()).contains(schema)) {
            LOG.debug("{} not allowed for {}", (Object)schema, any);
            return Collections.emptyList();
        }
        List<String> result = this.getValues(any, Collections.singleton(schema)).get(schema);
        return result == null ? Collections.emptyList() : result;
    }

    public Map<VirSchema, List<String>> getValues(Any<?> any) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForSelf());
    }

    public Map<VirSchema, List<String>> getValues(Any<?> any, Membership<?> membership) {
        return this.getValues(any, this.anyUtilsFactory.getInstance(any).dao().findAllowedSchemas(any, VirSchema.class).getForMembership((Group)membership.getRightEnd()));
    }
}

