/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.common.lib.types.FlowableEntitlement;
import org.apache.syncope.core.flowable.impl.FlowableDeployUtils;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.persistence.api.SyncopeLoader;
import org.apache.syncope.core.provisioning.api.EntitlementsHolder;
import org.apache.syncope.core.spring.ResourceWithFallbackLoader;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowableLoader
implements SyncopeLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FlowableLoader.class);
    @Resource(name="userWorkflowDef")
    private ResourceWithFallbackLoader userWorkflowDef;
    @Autowired
    private DomainProcessEngine dpEngine;

    public Integer getPriority() {
        return Integer.MIN_VALUE;
    }

    public void load() {
        EntitlementsHolder.getInstance().init((Collection)FlowableEntitlement.values());
        byte[] wfDef = new byte[]{};
        try (InputStream wfIn = this.userWorkflowDef.getResource().getInputStream();){
            wfDef = IOUtils.toByteArray((InputStream)wfIn);
        }
        catch (IOException e) {
            LOG.error("While loading " + this.userWorkflowDef.getResource().getFilename(), (Throwable)e);
        }
        for (Map.Entry entry : this.dpEngine.getEngines().entrySet()) {
            List processes = ((ProcessEngine)entry.getValue()).getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("userWorkflow").list();
            LOG.debug("userWorkflow Flowable processes in repository: {}", (Object)processes);
            if (processes.isEmpty()) {
                ((ProcessEngine)entry.getValue()).getRepositoryService().createDeployment().addInputStream(this.userWorkflowDef.getResource().getFilename(), (InputStream)new ByteArrayInputStream(wfDef)).deploy();
                ProcessDefinition procDef = (ProcessDefinition)((ProcessEngine)entry.getValue()).getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("userWorkflow").latestVersion().singleResult();
                FlowableDeployUtils.deployModel((ProcessEngine)((ProcessEngine)entry.getValue()), (ProcessDefinition)procDef);
                LOG.debug("Flowable Workflow definition loaded for domain {}", entry.getKey());
            }
            for (int i = 0; i < ((ProcessEngine)entry.getValue()).getProcessEngineConfiguration().getIdBlockSize(); ++i) {
                ((SpringProcessEngineConfiguration)SpringProcessEngineConfiguration.class.cast(((ProcessEngine)entry.getValue()).getProcessEngineConfiguration())).getIdGenerator().getNextId();
            }
        }
    }
}

