/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowTask;
import org.apache.syncope.common.lib.to.WorkflowTaskExecInput;
import org.apache.syncope.core.flowable.api.WorkflowTaskManager;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class UserWorkflowTaskLogic
extends AbstractTransactionalLogic<EntityTO> {
    @Autowired
    private WorkflowTaskManager wfTaskManager;
    @Autowired
    private PropagationManager propagationManager;
    @Autowired
    private PropagationTaskExecutor taskExecutor;
    @Autowired
    private UserDataBinder binder;
    @Autowired
    private UserDAO userDAO;

    @PreAuthorize(value="hasRole('WORKFLOW_TASK_LIST') and hasRole('USER_READ')")
    public List<WorkflowTask> getAvailableTasks(String key) {
        User user = (User)this.userDAO.authFind(key);
        return this.wfTaskManager.getAvailableTasks(user.getKey());
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public UserTO executeNextTask(WorkflowTaskExecInput workflowTaskExecInput) {
        WorkflowResult updated = this.wfTaskManager.executeNextTask(workflowTaskExecInput);
        UserPatch userPatch = new UserPatch();
        userPatch.setKey((String)updated.getResult());
        List taskInfos = this.propagationManager.getUserUpdateTasks(new WorkflowResult((Object)Pair.of((Object)userPatch, null), updated.getPropByRes(), updated.getPerformedTasks()));
        this.taskExecutor.execute((Collection)taskInfos, false);
        return this.binder.getUserTO((String)updated.getResult());
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

