/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.BpmnProcessFormat;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.flowable.api.BpmnProcessManager;
import org.apache.syncope.core.flowable.api.UserRequestHandler;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.propagation.PropagationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.flowable.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserRequestLogic
extends AbstractTransactionalLogic<EntityTO> {
    @Autowired
    protected BpmnProcessManager bpmnProcessManager;
    @Autowired
    protected UserRequestHandler userRequestHandler;
    @Autowired
    protected PropagationManager propagationManager;
    @Autowired
    protected PropagationTaskExecutor taskExecutor;
    @Autowired
    protected UserDataBinder binder;
    @Autowired
    protected UserDAO userDAO;

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public Pair<Integer, List<UserRequest>> list(String userKey, int page, int size, List<OrderByClause> orderByClauses) {
        if (userKey == null) {
            this.securityChecks(null, "USER_REQUEST_LIST", "Listing user requests not allowed");
        } else {
            User user = (User)this.userDAO.find(userKey);
            if (user == null) {
                throw new NotFoundException("User " + userKey);
            }
            this.securityChecks(user.getUsername(), "USER_REQUEST_LIST", "Listing requests for user" + user.getUsername() + " not allowed");
        }
        return this.userRequestHandler.getUserRequests(userKey, page, size, orderByClauses);
    }

    protected UserRequest doStart(String bpmnProcess, User user) {
        this.bpmnProcessManager.exportProcess(bpmnProcess, BpmnProcessFormat.XML, (OutputStream)new NullOutputStream());
        return this.userRequestHandler.start(bpmnProcess, user);
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserRequest start(String bpmnProcess) {
        return this.doStart(bpmnProcess, this.userDAO.findByUsername(AuthContextUtils.getUsername()));
    }

    @PreAuthorize(value="hasRole('USER_REQUEST_START')")
    public UserRequest start(String bpmnProcess, String userKey) {
        return this.doStart(bpmnProcess, (User)this.userDAO.authFind(userKey));
    }

    protected void securityChecks(String username, String entitlement, String errorMessage) {
        if (!AuthContextUtils.getUsername().equals(username) && !AuthContextUtils.getAuthorities().stream().anyMatch(auth -> entitlement.equals(auth.getAuthority()))) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.DelegatedAdministration);
            sce.getElements().add(errorMessage);
            throw sce;
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    public void cancel(String executionId, String reason) {
        Pair parsed = this.userRequestHandler.parse(executionId);
        this.securityChecks(((User)this.userDAO.find((String)parsed.getRight())).getUsername(), "USER_REQUEST_CANCEL", "Canceling " + executionId + " not allowed");
        this.userRequestHandler.cancel((ProcessInstance)parsed.getLeft(), reason);
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserRequestForm claimForm(String taskId) {
        UserRequestForm form = this.userRequestHandler.claimForm(taskId);
        this.securityChecks(form.getUsername(), "USER_REQUEST_FORM_CLAIM", "Claiming form " + taskId + " not allowed");
        return form;
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserRequestForm unclaimForm(String taskId) {
        UserRequestForm form = this.userRequestHandler.unclaimForm(taskId);
        this.securityChecks(form.getUsername(), "USER_REQUEST_FORM_UNCLAIM", "Unclaiming form " + taskId + " not allowed");
        return form;
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public Pair<Integer, List<UserRequestForm>> getForms(String userKey, int page, int size, List<OrderByClause> orderByClauses) {
        if (userKey == null) {
            this.securityChecks(null, "USER_REQUEST_FORM_LIST", "Listing forms not allowed");
        } else {
            User user = (User)this.userDAO.find(userKey);
            if (user == null) {
                throw new NotFoundException("User " + userKey);
            }
            this.securityChecks(user.getUsername(), "USER_REQUEST_FORM_LIST", "Listing forms for user" + user.getUsername() + " not allowed");
        }
        return this.userRequestHandler.getForms(userKey, page, size, orderByClauses);
    }

    @PreAuthorize(value="isAuthenticated()")
    public UserTO submitForm(UserRequestForm form) {
        UserTO userTO;
        if (form.getUsername() == null) {
            this.securityChecks(null, "USER_REQUEST_FORM_SUBMIT", "Submitting forms not allowed");
        } else {
            this.securityChecks(form.getUsername(), "USER_REQUEST_FORM_SUBMIT", "Submitting forms for user" + form.getUsername() + " not allowed");
        }
        WorkflowResult wfResult = this.userRequestHandler.submitForm(form);
        if (wfResult.getPropByRes() != null && !wfResult.getPropByRes().isEmpty()) {
            List taskInfos = this.propagationManager.getUserUpdateTasks(new WorkflowResult((Object)Pair.of((Object)wfResult.getResult(), (Object)Boolean.TRUE), wfResult.getPropByRes(), wfResult.getPerformedTasks()));
            this.taskExecutor.execute((Collection)taskInfos, false);
        }
        if (this.userDAO.find(((UserPatch)wfResult.getResult()).getKey()) == null) {
            userTO = new UserTO();
            userTO.setKey(((UserPatch)wfResult.getResult()).getKey());
        } else {
            userTO = this.binder.getUserTO(((UserPatch)wfResult.getResult()).getKey());
        }
        return userTO;
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

