/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.scim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.scim.SCIMComplexConf;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.syncope.common.lib.scim.SCIMUserAddressConf;
import org.apache.syncope.common.lib.scim.SCIMUserConf;
import org.apache.syncope.core.logic.scim.SCIMFilterBaseVisitor;
import org.apache.syncope.core.logic.scim.SCIMFilterParser;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.ext.scimv2.api.type.Resource;

public class SearchCondVisitor
extends SCIMFilterBaseVisitor<SearchCond> {
    private static final List<String> MULTIVALUE = Arrays.asList("emails", "phoneNumbers", "ims", "photos", "addresses");
    private final Resource resource;
    private final SCIMConf conf;

    public SearchCondVisitor(Resource resource, SCIMConf conf) {
        this.resource = resource;
        this.conf = conf;
    }

    @Override
    public SearchCond visitScimFilter(SCIMFilterParser.ScimFilterContext ctx) {
        return (SearchCond)this.visit((ParseTree)ctx.expression(0));
    }

    private boolean schemaEquals(Resource resource, String value, String schema) {
        return resource == null ? (value.contains(":") ? StringUtils.substringAfterLast((String)value, (String)":").equalsIgnoreCase(schema) : value.equalsIgnoreCase(schema)) : value.equalsIgnoreCase(schema) || (resource.schema() + ":" + value).equalsIgnoreCase(schema);
    }

    public AttributeCond createAttributeCond(String schema) {
        AnyCond attributeCond = null;
        if (this.schemaEquals(Resource.User, "userName", schema)) {
            attributeCond = new AnyCond();
            attributeCond.setSchema("username");
        } else if (this.resource == Resource.Group && this.schemaEquals(Resource.Group, "displayName", schema)) {
            attributeCond = new AnyCond();
            attributeCond.setSchema("name");
        } else if (this.schemaEquals(null, "meta.created", schema)) {
            attributeCond = new AnyCond();
            attributeCond.setSchema("creationDate");
        } else if (this.schemaEquals(null, "meta.lastModified", schema)) {
            attributeCond = new AnyCond();
            attributeCond.setSchema("lastChangeDate");
        }
        if (this.resource == Resource.User) {
            if (this.conf.getUserConf() != null) {
                if (this.conf.getUserConf().getName() != null) {
                    for (Map.Entry entry : this.conf.getUserConf().getName().asMap().entrySet()) {
                        if (!this.schemaEquals(Resource.User, "name." + (String)entry.getKey(), schema)) continue;
                        attributeCond = new AttributeCond();
                        attributeCond.setSchema((String)entry.getValue());
                    }
                }
                for (Map.Entry entry : this.conf.getUserConf().asMap().entrySet()) {
                    if (!this.schemaEquals(Resource.User, (String)entry.getKey(), schema)) continue;
                    attributeCond = new AttributeCond();
                    attributeCond.setSchema((String)entry.getValue());
                }
                for (SCIMUserAddressConf address : this.conf.getUserConf().getAddresses()) {
                    for (Map.Entry entry : address.asMap().entrySet()) {
                        if (!this.schemaEquals(Resource.User, "addresses." + (String)entry.getKey(), schema)) continue;
                        attributeCond = new AttributeCond();
                        attributeCond.setSchema((String)entry.getValue());
                    }
                }
            }
            if (this.conf.getEnterpriseUserConf() != null) {
                for (Map.Entry entry : this.conf.getEnterpriseUserConf().asMap().entrySet()) {
                    if (!this.schemaEquals(Resource.EnterpriseUser, (String)entry.getKey(), schema)) continue;
                    attributeCond = new AttributeCond();
                    attributeCond.setSchema((String)entry.getValue());
                }
                if (this.conf.getEnterpriseUserConf().getManager() != null && this.conf.getEnterpriseUserConf().getManager().getKey() != null) {
                    attributeCond = new AttributeCond();
                    attributeCond.setSchema(this.conf.getEnterpriseUserConf().getManager().getKey());
                }
            }
        }
        if (attributeCond == null) {
            throw new IllegalArgumentException("Could not match " + schema + " for " + this.resource);
        }
        return attributeCond;
    }

    private SearchCond setOperator(AttributeCond attributeCond, String operator) {
        switch (operator) {
            default: {
                attributeCond.setType(AttributeCond.Type.IEQ);
                break;
            }
            case "ne": {
                attributeCond.setType(AttributeCond.Type.IEQ);
                break;
            }
            case "sw": {
                attributeCond.setType(AttributeCond.Type.ILIKE);
                attributeCond.setExpression(attributeCond.getExpression() + "%");
                break;
            }
            case "co": {
                attributeCond.setType(AttributeCond.Type.ILIKE);
                attributeCond.setExpression("%" + attributeCond.getExpression() + "%");
                break;
            }
            case "ew": {
                attributeCond.setType(AttributeCond.Type.ILIKE);
                attributeCond.setExpression("%" + attributeCond.getExpression());
                break;
            }
            case "gt": {
                attributeCond.setType(AttributeCond.Type.GT);
                break;
            }
            case "ge": {
                attributeCond.setType(AttributeCond.Type.GE);
                break;
            }
            case "lt": {
                attributeCond.setType(AttributeCond.Type.LT);
                break;
            }
            case "le": {
                attributeCond.setType(AttributeCond.Type.LE);
            }
        }
        return "ne".equals(operator) ? SearchCond.getNotLeafCond((AttributeCond)attributeCond) : SearchCond.getLeafCond((AttributeCond)attributeCond);
    }

    private <E extends Enum<?>> SearchCond complex(String operator, String left, String right, List<SCIMComplexConf<E>> items) {
        if (left.endsWith(".type")) {
            Optional<SCIMComplexConf> item2 = items.stream().filter(object -> object.getType().name().equals(StringUtils.strip((String)right, (String)"\""))).findFirst();
            if (item2.isPresent()) {
                AttributeCond attributeCond = new AttributeCond();
                attributeCond.setSchema(item2.get().getValue());
                attributeCond.setType(AttributeCond.Type.ISNOTNULL);
                return SearchCond.getLeafCond((AttributeCond)attributeCond);
            }
        } else if (!this.conf.getUserConf().getEmails().isEmpty() && (MULTIVALUE.contains(left) || left.endsWith(".value"))) {
            ArrayList orConds = new ArrayList();
            items.forEach(item -> {
                AttributeCond cond = new AttributeCond();
                cond.setSchema(item.getValue());
                cond.setExpression(StringUtils.strip((String)right, (String)"\""));
                orConds.add(this.setOperator(cond, operator));
            });
            if (!orConds.isEmpty()) {
                return SearchCond.getOrCond(orConds);
            }
        }
        return null;
    }

    private SearchCond addresses(String operator, String left, String right, List<SCIMUserAddressConf> items) {
        if (left.endsWith(".type") && "eq".equals(operator)) {
            Optional<SCIMUserAddressConf> item2 = items.stream().filter(object -> object.getType().name().equals(StringUtils.strip((String)right, (String)"\""))).findFirst();
            if (item2.isPresent()) {
                AttributeCond attributeCond = new AttributeCond();
                attributeCond.setSchema(item2.get().getFormatted());
                attributeCond.setType(AttributeCond.Type.ISNOTNULL);
                return SearchCond.getLeafCond((AttributeCond)attributeCond);
            }
        } else if (!this.conf.getUserConf().getEmails().isEmpty() && (MULTIVALUE.contains(left) || left.endsWith(".value"))) {
            ArrayList orConds = new ArrayList();
            items.forEach(item -> {
                AttributeCond cond = new AttributeCond();
                cond.setSchema(item.getFormatted());
                cond.setExpression(StringUtils.strip((String)right, (String)"\""));
                orConds.add(this.setOperator(cond, operator));
            });
            if (!orConds.isEmpty()) {
                return SearchCond.getOrCond(orConds);
            }
        }
        return null;
    }

    private SearchCond transform(String operator, String left, String right) {
        SearchCond result = null;
        if (MULTIVALUE.contains(StringUtils.substringBefore((String)left, (String)"."))) {
            if (this.conf.getUserConf() == null) {
                throw new IllegalArgumentException("No " + SCIMUserConf.class.getName() + " provided, cannot continue");
            }
            switch (StringUtils.substringBefore((String)left, (String)".")) {
                case "emails": {
                    result = this.complex(operator, left, right, this.conf.getUserConf().getEmails());
                    break;
                }
                case "phoneNumbers": {
                    result = this.complex(operator, left, right, this.conf.getUserConf().getPhoneNumbers());
                    break;
                }
                case "ims": {
                    result = this.complex(operator, left, right, this.conf.getUserConf().getIms());
                    break;
                }
                case "photos": {
                    result = this.complex(operator, left, right, this.conf.getUserConf().getPhotos());
                    break;
                }
                case "addresses": {
                    result = this.addresses(operator, left, right, this.conf.getUserConf().getAddresses());
                    break;
                }
            }
        }
        if (result == null) {
            AttributeCond attributeCond = this.createAttributeCond(left);
            attributeCond.setExpression(StringUtils.strip((String)right, (String)"\""));
            result = this.setOperator(attributeCond, operator);
        }
        if (result == null) {
            throw new IllegalArgumentException("Could not handle (" + left + " " + operator + " " + right + ") for " + this.resource);
        }
        return result;
    }

    @Override
    public SearchCond visitEXPR_OPER_EXPR(SCIMFilterParser.EXPR_OPER_EXPRContext ctx) {
        return this.transform(ctx.operator().getText(), ctx.expression(0).getText(), ctx.expression(1).getText());
    }

    @Override
    public SearchCond visitATTR_OPER_CRITERIA(SCIMFilterParser.ATTR_OPER_CRITERIAContext ctx) {
        return this.transform(ctx.operator().getText(), ctx.ATTRNAME().getText(), ctx.criteria().getText());
    }

    @Override
    public SearchCond visitATTR_OPER_EXPR(SCIMFilterParser.ATTR_OPER_EXPRContext ctx) {
        return this.transform(ctx.operator().getText(), ctx.ATTRNAME().getText(), ctx.expression().getText());
    }

    @Override
    public SearchCond visitATTR_PR(SCIMFilterParser.ATTR_PRContext ctx) {
        AttributeCond cond = this.createAttributeCond(ctx.ATTRNAME().getText());
        cond.setType(AttributeCond.Type.ISNOTNULL);
        return SearchCond.getLeafCond((AttributeCond)cond);
    }

    @Override
    public SearchCond visitLPAREN_EXPR_RPAREN(SCIMFilterParser.LPAREN_EXPR_RPARENContext ctx) {
        return (SearchCond)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public SearchCond visitNOT_EXPR(SCIMFilterParser.NOT_EXPRContext ctx) {
        SearchCond cond = (SearchCond)this.visit((ParseTree)ctx.expression());
        if (cond.getAttributeCond() != null) {
            if (cond.getAttributeCond().getType() == AttributeCond.Type.ISNULL) {
                cond.getAttributeCond().setType(AttributeCond.Type.ISNOTNULL);
            } else if (cond.getAttributeCond().getType() == AttributeCond.Type.ISNOTNULL) {
                cond.getAttributeCond().setType(AttributeCond.Type.ISNULL);
            }
        } else if (cond.getAnyCond() != null) {
            if (cond.getAnyCond().getType() == AttributeCond.Type.ISNULL) {
                cond.getAnyCond().setType(AttributeCond.Type.ISNOTNULL);
            } else if (cond.getAnyCond().getType() == AttributeCond.Type.ISNOTNULL) {
                cond.getAnyCond().setType(AttributeCond.Type.ISNULL);
            }
        } else {
            cond = SearchCond.getNotLeafCond((SearchCond)cond);
        }
        return cond;
    }

    @Override
    public SearchCond visitEXPR_AND_EXPR(SCIMFilterParser.EXPR_AND_EXPRContext ctx) {
        return SearchCond.getAndCond((SearchCond)((SearchCond)this.visit((ParseTree)ctx.expression(0))), (SearchCond)((SearchCond)this.visit((ParseTree)ctx.expression(1))));
    }

    @Override
    public SearchCond visitEXPR_OR_EXPR(SCIMFilterParser.EXPR_OR_EXPRContext ctx) {
        return SearchCond.getOrCond((SearchCond)((SearchCond)this.visit((ParseTree)ctx.expression(0))), (SearchCond)((SearchCond)this.visit((ParseTree)ctx.expression(1))));
    }
}

