/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public abstract class AbstractUserWorkflowAdapter
implements UserWorkflowAdapter {
    protected static final Logger LOG = LoggerFactory.getLogger(UserWorkflowAdapter.class);
    @Autowired
    protected UserDataBinder dataBinder;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected EntityFactory entityFactory;

    public String getPrefix() {
        return null;
    }

    public WorkflowResult<Pair<String, Boolean>> create(UserTO userTO, boolean storePassword) {
        return this.create(userTO, false, null, storePassword);
    }

    protected abstract WorkflowResult<Pair<String, Boolean>> doCreate(UserTO var1, boolean var2, Boolean var3, boolean var4);

    public WorkflowResult<Pair<String, Boolean>> create(UserTO userTO, boolean disablePwdPolicyCheck, Boolean enabled, boolean storePassword) {
        return this.doCreate(userTO, disablePwdPolicyCheck, enabled, storePassword);
    }

    protected abstract WorkflowResult<String> doActivate(User var1, String var2);

    public WorkflowResult<String> activate(String key, String token) {
        return this.doActivate((User)this.userDAO.authFind(key), token);
    }

    protected abstract WorkflowResult<Pair<UserPatch, Boolean>> doUpdate(User var1, UserPatch var2);

    public WorkflowResult<Pair<UserPatch, Boolean>> update(UserPatch userPatch) {
        WorkflowResult<Pair<UserPatch, Boolean>> result = this.doUpdate((User)this.userDAO.authFind(userPatch.getKey()), userPatch);
        this.userDAO.authFind(userPatch.getKey());
        return result;
    }

    protected abstract WorkflowResult<String> doSuspend(User var1);

    public WorkflowResult<String> suspend(String key) {
        User user = (User)this.userDAO.authFind(key);
        user.setSuspended(Boolean.TRUE);
        return this.doSuspend(user);
    }

    public Pair<WorkflowResult<String>, Boolean> internalSuspend(String key) {
        User user = (User)this.userDAO.authFind(key);
        ImmutablePair result = null;
        Pair enforce = this.userDAO.enforcePolicies(user);
        if (((Boolean)enforce.getKey()).booleanValue()) {
            LOG.debug("User {} {} is over the max failed logins", (Object)user.getKey(), (Object)user.getUsername());
            user.setFailedLogins(Integer.valueOf(user.getFailedLogins() - 1));
            user.setSuspended(Boolean.TRUE);
            result = ImmutablePair.of(this.doSuspend(user), (Object)enforce.getValue());
        }
        return result;
    }

    protected abstract WorkflowResult<String> doReactivate(User var1);

    public WorkflowResult<String> reactivate(String key) {
        User user = (User)this.userDAO.authFind(key);
        user.setFailedLogins(Integer.valueOf(0));
        user.setSuspended(Boolean.FALSE);
        return this.doReactivate(user);
    }

    protected abstract void doRequestPasswordReset(User var1);

    public void requestPasswordReset(String key) {
        this.doRequestPasswordReset((User)this.userDAO.authFind(key));
    }

    protected abstract WorkflowResult<Pair<UserPatch, Boolean>> doConfirmPasswordReset(User var1, String var2, String var3);

    public WorkflowResult<Pair<UserPatch, Boolean>> confirmPasswordReset(String key, String token, String password) {
        return this.doConfirmPasswordReset((User)this.userDAO.authFind(key), token, password);
    }

    protected abstract void doDelete(User var1);

    public void delete(String userKey) {
        this.doDelete((User)this.userDAO.authFind(userKey));
    }
}

