/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectProvider;
import org.apache.cxf.rs.security.jose.jaxrs.JsonWebKeysProvider;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.common.UserInfo;
import org.apache.cxf.rs.security.oidc.rp.IdTokenReader;
import org.apache.cxf.rs.security.oidc.rp.UserInfoClient;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.OIDCLoginRequestTO;
import org.apache.syncope.common.lib.to.OIDCLoginResponseTO;
import org.apache.syncope.common.lib.to.OIDCLogoutRequestTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.model.TokenEndpointResponse;
import org.apache.syncope.core.logic.oidc.OIDCUserManager;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCProviderDAO;
import org.apache.syncope.core.persistence.api.entity.OIDCProvider;
import org.apache.syncope.core.persistence.api.entity.OIDCProviderItem;
import org.apache.syncope.core.provisioning.api.data.AccessTokenDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class OIDCClientLogic
extends AbstractTransactionalLogic<EntityTO> {
    private static final String JWT_CLAIM_OP_ENTITYID = "OP_ENTITYID";
    private static final String JWT_CLAIM_USERID = "USERID";
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Autowired
    private AuthDataAccessor authDataAccessor;
    @Autowired
    private AccessTokenDataBinder accessTokenDataBinder;
    @Autowired
    private OIDCProviderDAO opDAO;
    @Autowired
    private OIDCUserManager userManager;

    private OIDCProvider getOIDCProvider(String opName) {
        OIDCProvider op = null;
        if (StringUtils.isBlank((CharSequence)opName)) {
            List ops = this.opDAO.findAll();
            if (!ops.isEmpty()) {
                op = (OIDCProvider)ops.get(0);
            }
        } else {
            op = this.opDAO.findByName(opName);
        }
        if (op == null) {
            throw new NotFoundException(StringUtils.isBlank((CharSequence)opName) ? "Any OIDC Provider" : "OIDC Provider '" + opName + "'");
        }
        return op;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public OIDCLoginRequestTO createLoginRequest(String redirectURI, String opName) {
        OIDCProvider op = this.getOIDCProvider(opName);
        OIDCLoginRequestTO requestTO = new OIDCLoginRequestTO();
        requestTO.setProviderAddress(op.getAuthorizationEndpoint());
        requestTO.setClientId(op.getClientID());
        requestTO.setScope("openid email profile");
        requestTO.setResponseType("code");
        requestTO.setRedirectURI(redirectURI);
        requestTO.setState(SecureRandomUtils.generateRandomUUID().toString());
        return requestTO;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public OIDCLoginResponseTO login(String redirectURI, String authorizationCode, String opName) {
        String username;
        OIDCLoginResponseTO responseTO;
        IdToken idToken;
        block48: {
            TokenEndpointResponse tokenEndpointResponse;
            OIDCProvider op = this.getOIDCProvider(opName);
            String body = "code=" + authorizationCode + "&" + "client_id" + "=" + op.getClientID() + "&" + "client_secret" + "=" + op.getClientSecret() + "&" + "redirect_uri" + "=" + redirectURI + "&" + "grant_type" + "=" + "authorization_code";
            try {
                tokenEndpointResponse = this.getOIDCTokens(op.getTokenEndpoint(), body);
            }
            catch (IOException e) {
                LOG.error("Unexpected response for OIDC Tokens", (Throwable)e);
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
                sce.getElements().add("Unexpected response for OIDC Tokens: " + e.getMessage());
                throw sce;
            }
            Consumer consumer = new Consumer(op.getClientID(), op.getClientSecret());
            LOG.debug("Id Token to be validated: {}", (Object)tokenEndpointResponse.getIdToken());
            idToken = this.getValidatedIdToken(op, consumer, tokenEndpointResponse.getIdToken());
            responseTO = new OIDCLoginResponseTO();
            responseTO.setLogoutSupported(StringUtils.isNotBlank((CharSequence)op.getEndSessionEndpoint()));
            IdToken userInfo = StringUtils.isBlank((CharSequence)op.getUserinfoEndpoint()) ? idToken : this.getUserInfo(op.getUserinfoEndpoint(), tokenEndpointResponse.getAccessToken(), idToken, consumer);
            String keyValue = userInfo.getEmail();
            block38: for (OIDCProviderItem item : op.getItems()) {
                AttrTO attrTO = new AttrTO();
                attrTO.setSchema(item.getExtAttrName());
                switch (item.getExtAttrName()) {
                    case "preferred_username": {
                        attrTO.getValues().add(userInfo.getPreferredUserName());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getPreferredUserName();
                        continue block38;
                    }
                    case "profile": {
                        attrTO.getValues().add(userInfo.getProfile());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getProfile();
                        continue block38;
                    }
                    case "email": {
                        attrTO.getValues().add(userInfo.getEmail());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getEmail();
                        continue block38;
                    }
                    case "name": {
                        attrTO.getValues().add(userInfo.getName());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getName();
                        continue block38;
                    }
                    case "family_name": {
                        attrTO.getValues().add(userInfo.getFamilyName());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getFamilyName();
                        continue block38;
                    }
                    case "middle_name": {
                        attrTO.getValues().add(userInfo.getMiddleName());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getMiddleName();
                        continue block38;
                    }
                    case "given_name": {
                        attrTO.getValues().add(userInfo.getGivenName());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getGivenName();
                        continue block38;
                    }
                    case "nickname": {
                        attrTO.getValues().add(userInfo.getNickName());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getNickName();
                        continue block38;
                    }
                    case "gender": {
                        attrTO.getValues().add(userInfo.getGender());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getGender();
                        continue block38;
                    }
                    case "locale": {
                        attrTO.getValues().add(userInfo.getLocale());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getLocale();
                        continue block38;
                    }
                    case "zoneinfo": {
                        attrTO.getValues().add(userInfo.getZoneInfo());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getZoneInfo();
                        continue block38;
                    }
                    case "birthdate": {
                        attrTO.getValues().add(userInfo.getBirthDate());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getBirthDate();
                        continue block38;
                    }
                    case "phone_number": {
                        attrTO.getValues().add(userInfo.getPhoneNumber());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getPhoneNumber();
                        continue block38;
                    }
                    case "address": {
                        attrTO.getValues().add(userInfo.getUserAddress().getFormatted());
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = userInfo.getUserAddress().getFormatted();
                        continue block38;
                    }
                    case "updated_at": {
                        attrTO.getValues().add(Long.toString(userInfo.getUpdatedAt()));
                        responseTO.getAttrs().add(attrTO);
                        if (!item.isConnObjectKey()) continue block38;
                        keyValue = Long.toString(userInfo.getUpdatedAt());
                        continue block38;
                    }
                }
                String value = userInfo.getClaim(item.getExtAttrName()) == null ? null : userInfo.getClaim(item.getExtAttrName()).toString();
                attrTO.getValues().add(value);
                responseTO.getAttrs().add(attrTO);
                if (!item.isConnObjectKey()) continue;
                keyValue = value;
            }
            List matchingUsers = keyValue == null ? Collections.emptyList() : this.userManager.findMatchingUser(keyValue, (OIDCProviderItem)op.getConnObjectKeyItem().get());
            LOG.debug("Found {} matching users for {}", (Object)matchingUsers.size(), (Object)keyValue);
            if (matchingUsers.isEmpty()) {
                if (op.isCreateUnmatching()) {
                    LOG.debug("No user matching {}, about to create", (Object)keyValue);
                    String emailValue = userInfo.getEmail();
                    username = (String)AuthContextUtils.execWithAuthContext((String)AuthContextUtils.getDomain(), () -> this.userManager.create(op, responseTO, emailValue));
                    break block48;
                } else {
                    String string;
                    if (op.isSelfRegUnmatching()) {
                        UserTO userTO = new UserTO();
                        this.userManager.fill(op, responseTO, userTO);
                        responseTO.getAttrs().clear();
                        responseTO.getAttrs().addAll(userTO.getPlainAttrs());
                        responseTO.getAttrs().addAll(userTO.getVirAttrs());
                        if (StringUtils.isNotBlank((CharSequence)userTO.getUsername())) {
                            responseTO.setUsername(userTO.getUsername());
                        }
                        responseTO.setSelfReg(true);
                        return responseTO;
                    }
                    if (keyValue == null) {
                        string = "User marching the provided claims";
                        throw new NotFoundException(string);
                    }
                    string = "User matching the provided value " + keyValue;
                    throw new NotFoundException(string);
                }
            }
            if (matchingUsers.size() > 1) {
                throw new IllegalArgumentException("Several users match the provided value " + keyValue);
            }
            if (op.isUpdateMatching()) {
                LOG.debug("About to update {} for {}", matchingUsers.get(0), (Object)keyValue);
                username = (String)AuthContextUtils.execWithAuthContext((String)AuthContextUtils.getDomain(), () -> this.userManager.update((String)matchingUsers.get(0), op, responseTO));
            } else {
                username = (String)matchingUsers.get(0);
            }
        }
        responseTO.setUsername(username);
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put(JWT_CLAIM_OP_ENTITYID, idToken.getIssuer());
        claims.put(JWT_CLAIM_USERID, idToken.getSubject());
        byte[] authorities = null;
        try {
            authorities = ENCRYPTOR.encode(POJOHelper.serialize((Object)this.authDataAccessor.getAuthorities(responseTO.getUsername())), CipherAlgorithm.AES).getBytes();
        }
        catch (Exception e) {
            LOG.error("Could not fetch authorities", (Throwable)e);
        }
        Pair accessTokenInfo = this.accessTokenDataBinder.create(responseTO.getUsername(), claims, authorities, true);
        responseTO.setAccessToken((String)accessTokenInfo.getLeft());
        responseTO.setAccessTokenExpiryTime((Date)accessTokenInfo.getRight());
        return responseTO;
    }

    private TokenEndpointResponse getOIDCTokens(String url, String body) throws IOException {
        Response response = WebClient.create((String)url, Arrays.asList(new JacksonJsonProvider())).type("application/x-www-form-urlencoded").accept(new String[]{"application/json"}).post((Object)body);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            LOG.error("Unexpected response from OIDC Provider: {}\n{}\n{}", new Object[]{response.getStatus(), response.getHeaders(), IOUtils.toString((InputStream)((InputStream)response.getEntity()))});
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add("Unexpected response from OIDC Provider");
            throw sce;
        }
        return (TokenEndpointResponse)response.readEntity(TokenEndpointResponse.class);
    }

    private IdToken getValidatedIdToken(OIDCProvider op, Consumer consumer, String jwtIdToken) {
        IdToken idToken;
        IdTokenReader idTokenReader = new IdTokenReader();
        idTokenReader.setClockOffset(10);
        idTokenReader.setIssuerId(op.getIssuer());
        idTokenReader.setJwkSetClient(WebClient.create((String)op.getJwksUri(), Arrays.asList(new JsonWebKeysProvider())).accept(new String[]{"application/json"}));
        try {
            idToken = idTokenReader.getIdToken(jwtIdToken, consumer);
        }
        catch (Exception e) {
            LOG.error("While validating the id_token", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return idToken;
    }

    private UserInfo getUserInfo(String endpoint, String accessToken, IdToken idToken, Consumer consumer) {
        WebClient userInfoServiceClient = WebClient.create((String)endpoint, Arrays.asList(new JsonMapObjectProvider())).accept(new String[]{"application/json"});
        ClientAccessToken clientAccessToken = new ClientAccessToken("Bearer", accessToken);
        UserInfoClient userInfoClient = new UserInfoClient();
        userInfoClient.setUserInfoServiceClient(userInfoServiceClient);
        UserInfo userInfo = null;
        try {
            userInfo = userInfoClient.getUserInfo(clientAccessToken, idToken, consumer);
        }
        catch (Exception e) {
            LOG.error("While getting the userInfo", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        return userInfo;
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS'))")
    public OIDCLogoutRequestTO createLogoutRequest(String op) {
        OIDCLogoutRequestTO logoutRequest = new OIDCLogoutRequestTO();
        logoutRequest.setEndSessionEndpoint(this.getOIDCProvider(op).getEndSessionEndpoint());
        return logoutRequest;
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

