/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.saml2lsp.agent;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.SAML2LoginResponseTO;
import org.apache.syncope.common.rest.api.service.SAML2SPService;
import org.apache.syncope.ext.saml2lsp.agent.AbstractSAML2SPServlet;

@WebServlet(name="assertionConsumer", urlPatterns={"/saml2sp/assertion-consumer"})
public class AssertionConsumer
extends AbstractSAML2SPServlet {
    private static final long serialVersionUID = 968480296813639041L;
    private static final ObjectMapper MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SyncopeClient anonymous = (SyncopeClient)request.getServletContext().getAttribute("SyncopeAnonymousClient");
        try {
            SAML2LoginResponseTO responseTO = ((SAML2SPService)anonymous.getService(SAML2SPService.class)).validateLoginResponse(this.extract(StringUtils.substringBefore((String)request.getRequestURL().toString(), (String)"/saml2sp"), "saml2sp", request.getRemoteAddr(), (InputStream)request.getInputStream()));
            if (responseTO.isSelfReg()) {
                responseTO.getAttrs().add(new AttrTO.Builder().schema("username").values(new String[]{responseTO.getUsername()}).build());
                request.getSession(true).setAttribute("saml2sp.userattrs", (Object)MAPPER.writeValueAsString((Object)responseTO.getAttrs()));
                String selfRegRedirectURL = this.getServletContext().getInitParameter("saml2sp.redirect.selfreg");
                if (selfRegRedirectURL == null) {
                    request.setAttribute("responseTO", (Object)responseTO);
                    request.getRequestDispatcher("loginSuccess.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    response.sendRedirect(selfRegRedirectURL);
                }
            } else {
                request.getSession(true).setAttribute("saml2sp.jwt", (Object)responseTO.getAccessToken());
                request.getSession(true).setAttribute("saml2sp.jwt.expire", (Object)responseTO.getAccessTokenExpiryTime());
                String successURL = this.getServletContext().getInitParameter("saml2sp.login.success.url");
                if (successURL == null) {
                    request.setAttribute("responseTO", (Object)responseTO);
                    request.getRequestDispatcher("loginSuccess.jsp").forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    response.sendRedirect(successURL + "?sloSupported=" + responseTO.isSloSupported());
                }
            }
        }
        catch (Exception e) {
            LOG.error("While processing authentication response from IdP", (Throwable)e);
            String errorURL = this.getServletContext().getInitParameter("saml2sp.login.error.url");
            if (errorURL == null) {
                request.setAttribute("exception", (Object)e);
                request.getRequestDispatcher("loginError.jsp").forward((ServletRequest)request, (ServletResponse)response);
                e.printStackTrace(response.getWriter());
            }
            response.sendRedirect(errorURL + "?errorMessage=" + URLEncoder.encode(e.getMessage(), StandardCharsets.UTF_8.name()));
        }
    }
}

