/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.AttributableTO;

@XmlRootElement(name="membership")
@XmlType
public class MembershipTO
implements Serializable,
AttributableTO {
    private static final long serialVersionUID = 5992828670273935861L;
    private String groupKey;
    private String groupName;
    private final Set<AttrTO> plainAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> derAttrs = new HashSet<AttrTO>();
    private final Set<AttrTO> virAttrs = new HashSet<AttrTO>();

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    @XmlElementWrapper(name="plainAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="plainAttrs")
    public Set<AttrTO> getPlainAttrs() {
        return this.plainAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<AttrTO> getPlainAttr(String schema) {
        return this.plainAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    @XmlElementWrapper(name="derAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="derAttrs")
    public Set<AttrTO> getDerAttrs() {
        return this.derAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<AttrTO> getDerAttr(String schema) {
        return this.derAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    @XmlElementWrapper(name="virAttrs")
    @XmlElement(name="attribute")
    @JsonProperty(value="virAttrs")
    public Set<AttrTO> getVirAttrs() {
        return this.virAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<AttrTO> getVirAttr(String schema) {
        return this.virAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.groupKey).append((Object)this.groupName).append(this.plainAttrs).append(this.derAttrs).append(this.virAttrs).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MembershipTO other = (MembershipTO)obj;
        return new EqualsBuilder().append((Object)this.groupKey, (Object)other.groupKey).append((Object)this.groupName, (Object)other.groupName).append(this.plainAttrs, other.plainAttrs).append(this.derAttrs, other.derAttrs).append(this.virAttrs, other.virAttrs).build();
    }

    public static class Builder {
        private final MembershipTO instance = new MembershipTO();

        public Builder group(String groupKey) {
            this.instance.setGroupKey(groupKey);
            return this;
        }

        public Builder group(String groupKey, String groupName) {
            this.instance.setGroupKey(groupKey);
            this.instance.setGroupName(groupName);
            return this;
        }

        public MembershipTO build() {
            return this.instance;
        }
    }
}

