/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.PagedConnObjectTOResult;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.rest.api.beans.ConnObjectTOListQuery;
import org.apache.syncope.common.rest.api.service.ResourceService;
import org.apache.syncope.core.logic.AnyObjectLogic;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.ResourceLogic;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceServiceImpl
extends AbstractServiceImpl
implements ResourceService {
    @Autowired
    private ResourceLogic logic;
    @Autowired
    private AnyObjectLogic anyObjectLogic;
    @Autowired
    private UserLogic userLogic;
    @Autowired
    private GroupLogic groupLogic;

    public Response create(ResourceTO resourceTO) {
        ResourceTO created = this.logic.create(resourceTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created.getKey()).build();
    }

    public void update(ResourceTO resourceTO) {
        this.logic.update(resourceTO);
    }

    public void setLatestSyncToken(String key, String anyTypeKey) {
        this.logic.setLatestSyncToken(key, anyTypeKey);
    }

    public void removeSyncToken(String key, String anyTypeKey) {
        this.logic.removeSyncToken(key, anyTypeKey);
    }

    public void delete(String key) {
        this.logic.delete(key);
    }

    public ResourceTO read(String key) {
        return this.logic.read(key);
    }

    public List<ResourceTO> list() {
        return this.logic.list();
    }

    public ConnObjectTO readConnObject(String key, String anyTypeKey, String anyKey) {
        return this.logic.readConnObject(key, anyTypeKey, anyKey);
    }

    public PagedConnObjectTOResult listConnObjects(String key, String anyTypeKey, ConnObjectTOListQuery listQuery) {
        Pair list = this.logic.listConnObjects(key, anyTypeKey, listQuery.getSize().intValue(), listQuery.getPagedResultsCookie(), this.getOrderByClauses(listQuery.getOrderBy()));
        PagedConnObjectTOResult result = new PagedConnObjectTOResult();
        if (list.getLeft() != null) {
            result.setAllResultsReturned(((SearchResult)list.getLeft()).isAllResultsReturned());
            result.setPagedResultsCookie(((SearchResult)list.getLeft()).getPagedResultsCookie());
            result.setRemainingPagedResults(((SearchResult)list.getLeft()).getRemainingPagedResults());
        }
        result.getResult().addAll((Collection)list.getRight());
        UriBuilder builder = this.uriInfo.getAbsolutePathBuilder();
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        for (Map.Entry queryParam : queryParams.entrySet()) {
            builder = builder.queryParam((String)queryParam.getKey(), ((List)queryParam.getValue()).toArray());
        }
        if (StringUtils.isNotBlank((CharSequence)result.getPagedResultsCookie())) {
            result.setNext(builder.replaceQueryParam("connIdPagedResultsCookie", new Object[]{result.getPagedResultsCookie()}).replaceQueryParam("size", new Object[]{listQuery.getSize()}).build(new Object[0]));
        }
        return result;
    }

    public void check(ResourceTO resourceTO) {
        this.logic.check(resourceTO);
    }
}

