/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.syncope.common.lib.types.MailTemplateFormat;
import org.apache.syncope.common.rest.api.service.MailTemplateService;
import org.apache.syncope.core.logic.MailTemplateLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MailTemplateServiceImpl
extends AbstractServiceImpl
implements MailTemplateService {
    @Autowired
    private MailTemplateLogic logic;

    public Response create(MailTemplateTO mailTemplateTO) {
        MailTemplateTO created = this.logic.create(mailTemplateTO.getKey());
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created.getKey()).build();
    }

    public MailTemplateTO read(String key) {
        return this.logic.read(key);
    }

    public List<MailTemplateTO> list() {
        return this.logic.list();
    }

    public void delete(String key) {
        this.logic.delete(key);
    }

    public Response getFormat(String key, MailTemplateFormat format) {
        String template = this.logic.getFormat(key, format);
        StreamingOutput sout = os -> os.write(template.getBytes());
        return Response.ok((Object)sout).type(format.getMediaType()).build();
    }

    public void setFormat(String key, MailTemplateFormat format, InputStream templateIn) {
        try {
            this.logic.setFormat(key, format, IOUtils.toString((InputStream)templateIn, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.error("While setting format {} for mail template {}", new Object[]{format, key, e});
            throw new InternalServerErrorException("Could not read entity", (Throwable)e);
        }
    }

    public void removeFormat(String key, MailTemplateFormat format) {
        this.logic.setFormat(key, format, null);
    }
}

