/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ProvisionAction;
import org.apache.syncope.common.rest.api.service.GroupService;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.rest.cxf.service.AbstractAnyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupServiceImpl
extends AbstractAnyService<GroupTO, GroupPatch>
implements GroupService {
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private GroupLogic logic;

    @Override
    protected AnyDAO<?> getAnyDAO() {
        return this.groupDAO;
    }

    @Override
    protected AbstractAnyLogic<GroupTO, GroupPatch> getAnyLogic() {
        return this.logic;
    }

    @Override
    protected GroupPatch newPatch(String key) {
        GroupPatch patch = new GroupPatch();
        patch.setKey(key);
        return patch;
    }

    public Response create(GroupTO groupTO) {
        ProvisioningResult created = this.logic.create(groupTO, this.isNullPriorityAsync());
        return this.createResponse(created);
    }

    public Response update(GroupTO groupTO) {
        groupTO.setKey(this.getActualKey(this.getAnyDAO(), groupTO.getKey()));
        GroupTO before = this.logic.read(groupTO.getKey());
        this.checkETag(before.getETagValue());
        ProvisioningResult updated = this.logic.update(AnyOperations.diff((GroupTO)groupTO, (GroupTO)before, (boolean)false), this.isNullPriorityAsync());
        return this.modificationResponse(updated);
    }

    public Response update(GroupPatch groupPatch) {
        return this.doUpdate(groupPatch);
    }

    public List<GroupTO> own() {
        return this.logic.own();
    }

    public ExecTO provisionMembers(String key, ProvisionAction action) {
        return this.logic.provisionMembers(key, action);
    }
}

