/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.RealmCheck;

public class RealmValidator
extends AbstractValidator<RealmCheck, Realm> {
    private static final Pattern REALM_NAME_PATTERN = Pattern.compile("^[A-Za-z0-9]+");

    public boolean isValid(Realm realm, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if ("/".equals(realm.getName())) {
            if (realm.getParent() != null) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRealm, "Root realm cannot have a parent realm")).addPropertyNode("parent").addConstraintViolation();
            }
        } else {
            if (realm.getParent() == null) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRealm, "A realm needs to reference a parent realm")).addPropertyNode("parent").addConstraintViolation();
            }
            if (!REALM_NAME_PATTERN.matcher(realm.getName()).matches()) {
                isValid = false;
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidRealm, "Only alphanumeric chars allowed in realm name")).addPropertyNode("name").addConstraintViolation();
            }
        }
        return isValid;
    }
}

