/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.ConnPoolConf;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.ConnInstanceCheck;
import org.apache.syncope.core.provisioning.api.utils.ConnPoolConfUtils;
import org.apache.syncope.core.provisioning.api.utils.URIUtils;

public class ConnInstanceValidator
extends AbstractValidator<ConnInstanceCheck, ConnInstance> {
    public boolean isValid(ConnInstance connInstance, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (this.isHtml(connInstance.getDisplayName())) {
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidName, "Invalid display name")).addPropertyNode("displayName").addConstraintViolation();
            isValid = false;
        }
        try {
            URIUtils.buildForConnId((String)connInstance.getLocation());
        }
        catch (Exception e) {
            LOG.error("While validating {}", (Object)connInstance.getLocation(), (Object)e);
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidConnInstanceLocation, e.getMessage())).addPropertyNode("location").addConstraintViolation();
            isValid = false;
        }
        if (isValid && connInstance.getPoolConf() != null) {
            try {
                ConnPoolConfUtils.getObjectPoolConfiguration((ConnPoolConf)connInstance.getPoolConf()).validate();
            }
            catch (Exception e) {
                LOG.error("Invalid pool configuration", (Throwable)e);
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(this.getTemplate(EntityViolationType.InvalidConnPoolConf, e.getMessage())).addPropertyNode("poolConf").addConstraintViolation();
                isValid = false;
            }
        }
        return isValid;
    }
}

