/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.openjpa;

import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.AbstractValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.DBDictionary;

public class LocaleValueHandler
extends AbstractValueHandler {
    private static final long serialVersionUID = 487849441377630981L;
    private static final LocaleValueHandler INSTANCE = new LocaleValueHandler();

    public static LocaleValueHandler getInstance() {
        return INSTANCE;
    }

    public Column[] map(ValueMapping vm, String name, ColumnIO io, boolean adapt) {
        DBDictionary dict = vm.getMappingRepository().getDBDictionary();
        DBIdentifier colName = DBIdentifier.newColumn((String)name, (boolean)(dict != null ? dict.delimitAll() : false));
        return this.map(vm, colName, io, adapt);
    }

    public Column[] map(ValueMapping vm, DBIdentifier name, ColumnIO io, boolean adapt) {
        Column col = new Column();
        col.setIdentifier(name);
        col.setJavaType(9);
        return new Column[]{col};
    }

    public Object toDataStoreValue(ValueMapping vm, Object val, JDBCStore store) {
        return val == null ? null : ((Locale)val).toString();
    }

    public Object toObjectValue(ValueMapping vm, Object val) {
        return val == null ? null : LocaleUtils.toLocale((String)((String)val));
    }
}

