/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotNull;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.UserException;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAPlainSchema;
import org.apache.syncope.core.persistence.jpa.entity.PlainAttrListener;
import org.apache.syncope.core.persistence.jpa.validation.entity.PlainAttrCheck;

@MappedSuperclass
@PlainAttrCheck
@EntityListeners(value={PlainAttrListener.class})
public abstract class AbstractPlainAttr<O extends Any<?>>
extends AbstractGeneratedKeyEntity
implements PlainAttr<O> {
    private static final long serialVersionUID = -9115431608821806124L;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER)
    @Column(name="schema_id")
    protected JPAPlainSchema schema;
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAPlainSchema;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttr;

    public JPAPlainSchema getSchema() {
        return AbstractPlainAttr.pcGetschema(this);
    }

    public void setSchema(PlainSchema schema) {
        this.checkType(schema, JPAPlainSchema.class);
        AbstractPlainAttr.pcSetschema(this, (JPAPlainSchema)schema);
    }

    protected abstract boolean addForMultiValue(PlainAttrValue var1);

    private void checkNonNullSchema() {
        if (this.getSchema() == null) {
            throw new IllegalStateException("First set owner then schema and finally add values");
        }
    }

    public void add(String value, PlainAttrValue attrValue) {
        this.checkNonNullSchema();
        attrValue.setAttr((PlainAttr)this);
        this.getSchema().validator().validate(value, attrValue);
        if (this.getSchema().isUniqueConstraint()) {
            this.setUniqueValue((PlainAttrUniqueValue)attrValue);
        } else {
            if (!this.getSchema().isMultivalue()) {
                this.getValues().clear();
            }
            this.addForMultiValue(attrValue);
        }
    }

    public void add(String value, AnyUtils anyUtils) {
        PlainAttrValue attrValue;
        this.checkNonNullSchema();
        if (this.getSchema().isUniqueConstraint()) {
            attrValue = anyUtils.newPlainAttrUniqueValue();
            ((PlainAttrUniqueValue)attrValue).setSchema((PlainSchema)this.getSchema());
        } else {
            attrValue = anyUtils.newPlainAttrValue();
        }
        this.add(value, attrValue);
    }

    public List<String> getValuesAsStrings() {
        List<String> result = this.getUniqueValue() == null ? this.getValues().stream().map(value -> value.getValueAsString()).collect(Collectors.toList()) : Collections.singletonList(this.getUniqueValue().getValueAsString());
        return Collections.unmodifiableList(result);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1759663;
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity = AbstractPlainAttr.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"schema"};
        Class[] classArray = new Class[1];
        Class clazz2 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAPlainSchema != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAPlainSchema : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAPlainSchema = AbstractPlainAttr.class$("org.apache.syncope.core.persistence.jpa.entity.JPAPlainSchema"));
        classArray[0] = clazz2;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26};
        Class clazz3 = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttr != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttr : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttr = AbstractPlainAttr.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractPlainAttr"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AbstractPlainAttr", null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.schema = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        throw new UserException();
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        throw new UserException();
    }

    protected static int pcGetManagedFieldCount() {
        return 1 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.schema = (JPAPlainSchema)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.schema);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AbstractPlainAttr abstractPlainAttr, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(abstractPlainAttr, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.schema = abstractPlainAttr.schema;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        AbstractPlainAttr abstractPlainAttr = (AbstractPlainAttr)object;
        if (abstractPlainAttr.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(abstractPlainAttr, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttr != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttr : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractPlainAttr = AbstractPlainAttr.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractPlainAttr"));
        return clazz;
    }

    protected static final JPAPlainSchema pcGetschema(AbstractPlainAttr abstractPlainAttr) {
        if (abstractPlainAttr.pcStateManager == null) {
            return abstractPlainAttr.schema;
        }
        int n = pcInheritedFieldCount + 0;
        abstractPlainAttr.pcStateManager.accessingField(n);
        return abstractPlainAttr.schema;
    }

    protected static final void pcSetschema(AbstractPlainAttr abstractPlainAttr, JPAPlainSchema jPAPlainSchema) {
        if (abstractPlainAttr.pcStateManager == null) {
            abstractPlainAttr.schema = jPAPlainSchema;
            return;
        }
        abstractPlainAttr.pcStateManager.settingObjectField((PersistenceCapable)abstractPlainAttr, pcInheritedFieldCount + 0, (Object)abstractPlainAttr.schema, (Object)jPAPlainSchema, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

