/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collection;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.dao.JPAPlainAttrDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAPlainSchema;
import org.springframework.beans.factory.annotation.Autowired;

public class JPAPlainSchemaDAO
extends AbstractDAO<PlainSchema>
implements PlainSchemaDAO {
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;
    @Autowired
    private PlainAttrDAO plainAttrDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;

    public PlainSchema find(String key) {
        return (PlainSchema)this.entityManager().find(JPAPlainSchema.class, (Object)key);
    }

    public List<PlainSchema> findByAnyTypeClasses(Collection<AnyTypeClass> anyTypeClasses) {
        StringBuilder queryString = new StringBuilder("SELECT e FROM ").append(JPAPlainSchema.class.getSimpleName()).append(" e WHERE ");
        anyTypeClasses.forEach(anyTypeClass -> queryString.append("e.anyTypeClass.id='").append(anyTypeClass.getKey()).append("' OR "));
        TypedQuery query = this.entityManager().createQuery(queryString.substring(0, queryString.length() - 4), PlainSchema.class);
        return query.getResultList();
    }

    public List<PlainSchema> findByValidator(Implementation validator) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPlainSchema.class.getSimpleName() + " e WHERE e.validator=:validator", PlainSchema.class);
        query.setParameter("validator", (Object)validator);
        return query.getResultList();
    }

    public List<PlainSchema> findByKeyword(String keyword) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPlainSchema.class.getSimpleName() + " e WHERE e.id LIKE :keyword", PlainSchema.class);
        query.setParameter("keyword", (Object)keyword);
        return query.getResultList();
    }

    public List<PlainSchema> findAll() {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPlainSchema.class.getSimpleName() + " e", PlainSchema.class);
        return query.getResultList();
    }

    public <T extends PlainAttr<?>> List<T> findAttrs(PlainSchema schema, Class<T> reference) {
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAPlainAttrDAO.getEntityReference(reference).getSimpleName() + " e WHERE e.schema=:schema", reference);
        query.setParameter("schema", (Object)schema);
        return query.getResultList();
    }

    public PlainSchema save(PlainSchema schema) {
        return (PlainSchema)this.entityManager().merge((Object)schema);
    }

    protected void deleteAttrs(PlainSchema schema) {
        for (AnyTypeKind anyTypeKind : AnyTypeKind.values()) {
            AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyTypeKind);
            this.findAttrs(schema, anyUtils.plainAttrClass()).forEach(attr -> this.plainAttrDAO.delete(attr));
        }
    }

    public void delete(String key) {
        PlainSchema schema = this.find(key);
        if (schema == null) {
            return;
        }
        schema.getLabels().forEach(label -> label.setSchema(null));
        this.deleteAttrs(schema);
        this.resourceDAO.deleteMapping(key);
        if (schema.getAnyTypeClass() != null) {
            schema.getAnyTypeClass().getPlainSchemas().remove(schema);
        }
        this.entityManager().remove((Object)schema);
    }
}

