/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceHistoryConfDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.jpa.dao.AbstractDAO;
import org.apache.syncope.core.persistence.jpa.entity.JPAConnInstance;
import org.apache.syncope.core.provisioning.api.ConnectorRegistry;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JPAConnInstanceDAO
extends AbstractDAO<ConnInstance>
implements ConnInstanceDAO {
    @Autowired
    private ConnInstanceHistoryConfDAO connInstanceHistoryConfDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private ConnectorRegistry connRegistry;

    public ConnInstance find(String key) {
        return (ConnInstance)this.entityManager().find(JPAConnInstance.class, (Object)key);
    }

    public ConnInstance authFind(String key) {
        ConnInstance connInstance = this.find(key);
        if (connInstance == null) {
            return null;
        }
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("CONNECTOR_READ");
        if (authRealms == null || authRealms.isEmpty() || !authRealms.stream().anyMatch(realm -> connInstance.getAdminRealm().getFullPath().startsWith((String)realm))) {
            throw new DelegatedAdministrationException(connInstance.getAdminRealm().getFullPath(), ConnInstance.class.getSimpleName(), connInstance.getKey());
        }
        return connInstance;
    }

    public List<ConnInstance> findAll() {
        Set authRealms = (Set)AuthContextUtils.getAuthorizations().get("CONNECTOR_LIST");
        if (authRealms == null || authRealms.isEmpty()) {
            return Collections.emptyList();
        }
        TypedQuery query = this.entityManager().createQuery("SELECT e FROM " + JPAConnInstance.class.getSimpleName() + " e", ConnInstance.class);
        return query.getResultList().stream().filter(connInstance -> authRealms.stream().anyMatch(realm -> connInstance.getAdminRealm().getFullPath().startsWith((String)realm))).collect(Collectors.toList());
    }

    public ConnInstance save(ConnInstance connector) {
        ConnInstance merged = (ConnInstance)this.entityManager().merge((Object)connector);
        merged.getResources().forEach(resource -> {
            try {
                this.connRegistry.registerConnector(resource);
            }
            catch (NotFoundException e) {
                LOG.error("While registering connector for resource", (Throwable)e);
            }
        });
        return merged;
    }

    public void delete(String key) {
        ConnInstance connInstance = this.find(key);
        if (connInstance == null) {
            return;
        }
        connInstance.getResources().stream().map(Entity::getKey).collect(Collectors.toList()).forEach(resource -> this.resourceDAO.delete(resource));
        this.connInstanceHistoryConfDAO.deleteByEntity(connInstance);
        this.entityManager().remove((Object)connInstance);
        this.connRegistry.unregisterConnector(key);
    }
}

