/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.DefaultAccountRuleConf;
import org.apache.syncope.core.persistence.api.dao.AccountRule;
import org.apache.syncope.core.persistence.api.dao.AccountRuleConfClass;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.utils.policy.AccountPolicyException;
import org.springframework.transaction.annotation.Transactional;

@AccountRuleConfClass(value=DefaultAccountRuleConf.class)
public class DefaultAccountRule
implements AccountRule {
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("[a-zA-Z0-9-_@. ]+");
    private DefaultAccountRuleConf conf;

    public void setConf(AccountRuleConf conf) {
        if (!(conf instanceof DefaultAccountRuleConf)) {
            throw new IllegalArgumentException(DefaultAccountRuleConf.class.getName() + " expected, got " + conf.getClass().getName());
        }
        this.conf = (DefaultAccountRuleConf)DefaultAccountRuleConf.class.cast(conf);
    }

    @Transactional(readOnly=true)
    public void enforce(User user) {
        Pattern pattern;
        this.conf.getSchemasNotPermitted().stream().map(schema -> user.getPlainAttr(schema)).filter(Optional::isPresent).map(attr -> ((UPlainAttr)attr.get()).getValuesAsStrings()).filter(values -> values != null && !values.isEmpty()).forEachOrdered(values -> this.conf.getWordsNotPermitted().add(values.get(0)));
        if (user.getUsername() == null) {
            throw new AccountPolicyException("Invalid account");
        }
        if (this.conf.getMinLength() > 0 && this.conf.getMinLength() > user.getUsername().length()) {
            throw new AccountPolicyException("Username too short");
        }
        if (this.conf.getMaxLength() > 0 && this.conf.getMaxLength() < user.getUsername().length()) {
            throw new AccountPolicyException("Username too long");
        }
        this.conf.getWordsNotPermitted().stream().filter(word -> StringUtils.containsIgnoreCase((CharSequence)user.getUsername(), (CharSequence)word)).forEachOrdered(item -> {
            throw new AccountPolicyException("Used word(s) not permitted");
        });
        if (this.conf.isAllUpperCase() && !user.getUsername().equals(user.getUsername().toUpperCase())) {
            throw new AccountPolicyException("No lowercase characters permitted");
        }
        if (this.conf.isAllLowerCase() && !user.getUsername().equals(user.getUsername().toLowerCase())) {
            throw new AccountPolicyException("No uppercase characters permitted");
        }
        Pattern pattern2 = pattern = this.conf.getPattern() == null ? DEFAULT_PATTERN : Pattern.compile(this.conf.getPattern());
        if (!pattern.matcher(user.getUsername()).matches()) {
            throw new AccountPolicyException("Username does not match pattern");
        }
        this.conf.getPrefixesNotPermitted().stream().filter(prefix -> user.getUsername().startsWith((String)prefix)).forEachOrdered(item -> {
            throw new AccountPolicyException("Prefix not permitted");
        });
        this.conf.getSuffixesNotPermitted().stream().filter(suffix -> user.getUsername().endsWith((String)suffix)).forEachOrdered(item -> {
            throw new AccountPolicyException("Suffix not permitted");
        });
    }
}

