/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.test;

import java.util.Timer;
import java.util.TimerTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.test.FlowableRule;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;

public class HistoryTestHelper {
    public static boolean isHistoryLevelAtLeast(HistoryLevel historyLevel, ProcessEngineConfigurationImpl processEngineConfiguration) {
        return HistoryTestHelper.isHistoryLevelAtLeast(historyLevel, processEngineConfiguration, 10000L);
    }

    public static boolean isHistoryLevelAtLeast(HistoryLevel historyLevel, ProcessEngineConfigurationImpl processEngineConfiguration, long time) {
        if (processEngineConfiguration.getHistoryLevel().isAtLeast(historyLevel)) {
            if (processEngineConfiguration.isAsyncHistoryEnabled()) {
                HistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(processEngineConfiguration, processEngineConfiguration.getManagementService(), time, 200L);
            }
            return true;
        }
        return false;
    }

    public static void waitForJobExecutorToProcessAllHistoryJobs(FlowableRule activitiRule, long maxMillisToWait, long intervalMillis) {
        HistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(activitiRule.getProcessEngine().getProcessEngineConfiguration(), activitiRule.getManagementService(), maxMillisToWait, intervalMillis);
    }

    public static void waitForJobExecutorToProcessAllHistoryJobs(ProcessEngineConfiguration processEngineConfiguration, ManagementService managementService, long maxMillisToWait, long intervalMillis) {
        HistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(processEngineConfiguration, managementService, maxMillisToWait, intervalMillis, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForJobExecutorToProcessAllHistoryJobs(ProcessEngineConfiguration processEngineConfiguration, ManagementService managementService, long maxMillisToWait, long intervalMillis, boolean shutdownExecutorWhenFinished) {
        ProcessEngineConfigurationImpl processEngineConfigurationImpl = (ProcessEngineConfigurationImpl)processEngineConfiguration;
        if (processEngineConfigurationImpl.isAsyncHistoryEnabled()) {
            AsyncExecutor asyncHistoryExecutor = processEngineConfiguration.getAsyncHistoryExecutor();
            if (!asyncHistoryExecutor.isActive()) {
                asyncHistoryExecutor.start();
            }
            try {
                Timer timer = new Timer();
                InterruptTask task = new InterruptTask(Thread.currentThread());
                timer.schedule((TimerTask)task, maxMillisToWait);
                boolean areJobsAvailable = true;
                try {
                    while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                        Thread.sleep(intervalMillis);
                        try {
                            areJobsAvailable = HistoryTestHelper.areHistoryJobsAvailable(managementService);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    timer.cancel();
                }
                if (areJobsAvailable) {
                    throw new FlowableException("time limit of " + maxMillisToWait + " was exceeded");
                }
            }
            finally {
                if (shutdownExecutorWhenFinished) {
                    asyncHistoryExecutor.shutdown();
                }
            }
        }
    }

    public static boolean areHistoryJobsAvailable(FlowableRule activitiRule) {
        return HistoryTestHelper.areHistoryJobsAvailable(activitiRule.getManagementService());
    }

    public static boolean areHistoryJobsAvailable(ManagementService managementService) {
        return !managementService.createHistoryJobQuery().list().isEmpty();
    }

    public static boolean isHistoricTaskLoggingEnabled(ProcessEngineConfiguration configuration) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)configuration;
        if (processEngineConfiguration.isEnableHistoricTaskLogging()) {
            if (processEngineConfiguration.isAsyncHistoryEnabled()) {
                HistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(processEngineConfiguration, processEngineConfiguration.getManagementService(), 10000L, 200L);
            }
            return true;
        }
        return false;
    }

    private static class InterruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded;
        protected Thread thread;

        public InterruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

