/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ConnBundleTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;

public class ConnectorDetailsPanel
extends WizardStep {
    private static final long serialVersionUID = -2435937897614232137L;
    private final LoadableDetachableModel<List<String>> realms;

    public ConnectorDetailsPanel(final ConnInstanceTO connInstanceTO, final List<ConnBundleTO> bundles) {
        this.setOutputMarkupId(true);
        final List<String> authRealms = SyncopeConsoleSession.get().getAuthRealms();
        this.realms = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return new RealmRestClient().list().stream().filter(realm -> authRealms.stream().anyMatch(authRealm -> realm.getFullPath().startsWith((String)authRealm))).map(RealmTO::getFullPath).sorted().collect(Collectors.toList());
            }
        };
        AjaxDropDownChoicePanel realm = new AjaxDropDownChoicePanel("adminRealm", "adminRealm", new PropertyModel((Object)connInstanceTO, "adminRealm"), false);
        realm.setChoices(this.realms);
        realm.setOutputMarkupId(true);
        realm.addRequiredLabel();
        this.add(new Component[]{realm});
        AjaxTextFieldPanel displayName = new AjaxTextFieldPanel("displayName", "displayName", (IModel<String>)new PropertyModel((Object)connInstanceTO, "displayName"), false);
        displayName.setOutputMarkupId(true);
        displayName.addRequiredLabel();
        this.add(new Component[]{displayName});
        AjaxTextFieldPanel location = new AjaxTextFieldPanel("location", "location", (IModel<String>)new PropertyModel((Object)connInstanceTO, "location"), false);
        location.addRequiredLabel();
        location.setOutputMarkupId(true);
        location.setEnabled(false);
        this.add(new Component[]{location});
        final AjaxDropDownChoicePanel bundleName = new AjaxDropDownChoicePanel("bundleName", "bundleName", new PropertyModel((Object)connInstanceTO, "bundleName"), false);
        ((DropDownChoice)bundleName.getField()).setNullValid(true);
        ArrayList bundleNames = new ArrayList();
        bundles.stream().filter(bundle -> !bundleNames.contains(bundle.getBundleName())).forEachOrdered(bundle -> bundleNames.add(bundle.getBundleName()));
        bundleName.setChoices(bundleNames);
        bundleName.addRequiredLabel();
        bundleName.setOutputMarkupId(true);
        bundleName.setEnabled(connInstanceTO.getKey() == null);
        bundleName.getField().setOutputMarkupId(true);
        this.add(new Component[]{bundleName});
        final AjaxDropDownChoicePanel version = new AjaxDropDownChoicePanel("version", "version", new PropertyModel((Object)connInstanceTO, "version"), false);
        version.setChoices(this.getVersions(connInstanceTO, bundles));
        version.addRequiredLabel();
        version.setEnabled(connInstanceTO.getBundleName() != null);
        version.setOutputMarkupId(true);
        version.getField().setOutputMarkupId(true);
        this.add(new Component[]{version});
        bundleName.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ((DropDownChoice)bundleName.getField()).setNullValid(false);
                version.setEnabled(true);
                List versions = ConnectorDetailsPanel.this.getVersions(connInstanceTO, bundles);
                if (versions.size() == 1) {
                    connInstanceTO.setVersion((String)versions.get(0));
                    version.getField().setModelObject(versions.get(0));
                }
                version.setChoices(versions);
                target.add(new Component[]{version});
            }
        }});
        if (connInstanceTO.getPoolConf() == null) {
            connInstanceTO.setPoolConf(new ConnPoolConfTO());
        }
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Integer>().min(0).max(Integer.MAX_VALUE).build("connRequestTimeout", "connRequestTimeout", Integer.class, (IModel<Integer>)new PropertyModel((Object)connInstanceTO, "connRequestTimeout"))});
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Integer>().min(0).max(Integer.MAX_VALUE).build("poolMaxObjects", "poolMaxObjects", Integer.class, (IModel<Integer>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxObjects"))});
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Integer>().min(0).max(Integer.MAX_VALUE).build("poolMinIdle", "poolMinIdle", Integer.class, (IModel<Integer>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "minIdle"))});
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Integer>().min(0).max(Integer.MAX_VALUE).build("poolMaxIdle", "poolMaxIdle", Integer.class, (IModel<Integer>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxIdle"))});
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Long>().min(0L).max(Long.MAX_VALUE).build("poolMaxWait", "poolMaxWait", Long.class, (IModel<Long>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "maxWait"))});
        this.add(new Component[]{new AjaxSpinnerFieldPanel.Builder<Long>().min(0L).max(Long.MAX_VALUE).build("poolMinEvictableIdleTime", "poolMinEvictableIdleTime", Long.class, (IModel<Long>)new PropertyModel((Object)connInstanceTO.getPoolConf(), "minEvictableIdleTimeMillis"))});
    }

    private List<String> getVersions(ConnInstanceTO connInstanceTO, List<ConnBundleTO> bundles) {
        return bundles.stream().filter(object -> object.getLocation().equals(connInstanceTO.getLocation()) && object.getBundleName().equals(connInstanceTO.getBundleName())).map(ConnBundleTO::getVersion).collect(Collectors.toList());
    }
}

