/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.layout.UserForm;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.AnyWizardBuilder;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.Details;
import org.apache.syncope.client.console.wizards.any.UserDetails;
import org.apache.syncope.client.console.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.PageReference;

public class UserWizardBuilder
extends AnyWizardBuilder<UserTO>
implements UserForm {
    private static final long serialVersionUID = 6716803168859873877L;
    protected final UserRestClient userRestClient = new UserRestClient();

    public UserWizardBuilder(List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageRef) {
        super(new UserWrapper(null), anyTypeClasses, formLayoutInfo, pageRef);
    }

    public UserWizardBuilder(UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageRef) {
        super(new UserWrapper(previousUserTO, userTO), anyTypeClasses, formLayoutInfo, pageRef);
    }

    @Override
    protected Serializable onApplyInternal(AnyWrapper<UserTO> modelObject) {
        ProvisioningResult<UserTO> result;
        UserTO inner = modelObject.getInnerObject();
        if (inner.getKey() == null) {
            result = this.userRestClient.create(inner, modelObject instanceof UserWrapper ? ((UserWrapper)UserWrapper.class.cast(modelObject)).isStorePasswordInSyncope() : StringUtils.isNotBlank((CharSequence)inner.getPassword()));
        } else {
            this.fixPlainAndVirAttrs((AnyTO)inner, (AnyTO)((AnyWrapper)this.getOriginalItem()).getInnerObject());
            UserPatch patch = AnyOperations.diff((UserTO)inner, (UserTO)((UserTO)((AnyWrapper)this.getOriginalItem()).getInnerObject()), (boolean)false);
            if (StringUtils.isNotBlank((CharSequence)inner.getPassword())) {
                PasswordPatch passwordPatch = (PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)inner.getPassword())).onSyncope(true).resources((Collection)inner.getResources()).build();
                patch.setPassword(passwordPatch);
            }
            if (patch.isEmpty()) {
                result = new ProvisioningResult<UserTO>();
                result.setEntity((EntityTO)inner);
            } else {
                result = this.userRestClient.update(((UserTO)((AnyWrapper)this.getOriginalItem()).getInnerObject()).getETagValue(), patch);
            }
        }
        return result;
    }

    @Override
    protected Details<UserTO> addOptionalDetailsPanel(AnyWrapper<UserTO> modelObject) {
        return new UserDetails((UserWrapper)UserWrapper.class.cast(modelObject), this.mode == AjaxWizard.Mode.TEMPLATE, modelObject.getInnerObject().getKey() != null, ((UserFormLayoutInfo)UserFormLayoutInfo.class.cast(this.formLayoutInfo)).isPasswordManagement(), this.pageRef);
    }

    public UserWizardBuilder setItem(AnyWrapper<UserTO> item) {
        super.setItem(item == null ? null : new UserWrapper(item.getInnerObject()));
        return this;
    }
}

