/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.DynRealmRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.wicket.ajax.markup.html.LabelInfo;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.UserWrapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.search.GroupFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.DynRealmTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.ActionPermissions;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public class Groups
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = 552437609667518888L;
    private static final int MAX_GROUP_LIST_CARDINALITY = 30;
    private final GroupRestClient groupRestClient = new GroupRestClient();
    private final List<DynRealmTO> allDynRealms = new DynRealmRestClient().list();
    private GroupsModel groupsModel;
    private final AnyTO anyTO;
    private boolean templateMode;
    protected WebMarkupContainer dyngroupsContainer;
    protected WebMarkupContainer dynrealmsContainer;

    public <T extends AnyTO> Groups(AnyWrapper<T> modelObject, boolean templateMode) {
        this.templateMode = templateMode;
        this.anyTO = modelObject.getInnerObject();
        this.groupsModel = new GroupsModel();
        ActionPermissions permissions = new ActionPermissions();
        this.setMetaData(MetaDataRoleAuthorizationStrategy.ACTION_PERMISSIONS, (Serializable)permissions);
        permissions.authorizeAll(RENDER);
        this.setOutputMarkupId(true);
        WebMarkupContainer groupsContainer = new WebMarkupContainer("groupsContainer");
        groupsContainer.setOutputMarkupId(true);
        groupsContainer.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{groupsContainer});
        this.dyngroupsContainer = new WebMarkupContainer("dyngroupsContainer");
        this.dyngroupsContainer.setOutputMarkupId(true);
        this.dyngroupsContainer.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{this.dyngroupsContainer});
        if (this.anyTO instanceof GroupTO) {
            groupsContainer.add(new Component[]{new Label("groups").setVisible(false)});
            groupsContainer.setVisible(false);
            this.dyngroupsContainer.add(new Component[]{new Label("dyngroups").setVisible(false)});
            this.dyngroupsContainer.setVisible(false);
        } else {
            AjaxPalettePanel.Builder<MembershipTO> builder = new AjaxPalettePanel.Builder<MembershipTO>().setRenderer(new IChoiceRenderer<MembershipTO>(){
                private static final long serialVersionUID = -3086661086073628855L;

                public Object getDisplayValue(MembershipTO object) {
                    return object.getGroupName();
                }

                public String getIdValue(MembershipTO object, int index) {
                    return object.getGroupName();
                }

                public MembershipTO getObject(String id, IModel<? extends List<? extends MembershipTO>> choices) {
                    return ((List)choices.getObject()).stream().filter(object -> id.equalsIgnoreCase(object.getGroupName())).findAny().orElse(null);
                }
            });
            groupsContainer.add(new Component[]{builder.setAllowOrder(true).withFilter().build("groups", (IModel<List<MembershipTO>>)new ListModel<MembershipTO>(){
                private static final long serialVersionUID = -2583290457773357445L;

                public List<MembershipTO> getObject() {
                    return Groups.this.groupsModel.getMemberships();
                }
            }, new AjaxPalettePanel.Builder.Query<MembershipTO>(){
                private static final long serialVersionUID = -7223078772249308813L;

                @Override
                public List<MembershipTO> execute(String filter) {
                    return (StringUtils.isEmpty((CharSequence)filter) || "*".equals(filter) ? Groups.this.groupsModel.getObject() : Groups.this.groupRestClient.search(Groups.this.anyTO.getRealm(), SyncopeClient.getGroupSearchConditionBuilder().isAssignable().and().is("name").equalTo(filter, new String[0]).query(), 1, 30, (SortParam<String>)new SortParam((Object)"name", true), null)).stream().map(input -> new MembershipTO.Builder().group(input.getKey(), input.getName()).build()).collect(Collectors.toList());
                }
            }).hideLabel().setOutputMarkupId(true)});
            this.dyngroupsContainer.add(new Component[]{new AjaxPalettePanel.Builder().setAllowOrder(true).build("dyngroups", new ListModel<String>(){
                private static final long serialVersionUID = -2583290457773357445L;

                public List<String> getObject() {
                    return Groups.this.groupsModel.getDynMemberships();
                }
            }, new ListModel(this.groupsModel.getObject().stream().map(GroupTO::getName).collect(Collectors.toList()))).hideLabel().setEnabled(false).setOutputMarkupId(true)});
        }
        this.dynrealmsContainer = new WebMarkupContainer("dynrealmsContainer");
        this.dynrealmsContainer.setOutputMarkupId(true);
        this.dynrealmsContainer.setOutputMarkupPlaceholderTag(true);
        this.dynrealmsContainer.add(new Component[]{new AjaxPalettePanel.Builder().build("dynrealms", new PropertyModel((Object)this.anyTO, "dynRealms"), new ListModel(this.allDynRealms.stream().map(EntityTO::getKey).collect(Collectors.toList()))).hideLabel().setEnabled(false).setOutputMarkupId(true)});
        this.add(new Component[]{this.dynrealmsContainer});
        if (modelObject instanceof UserWrapper && ((UserWrapper)UserWrapper.class.cast(modelObject)).getPreviousUserTO() != null && !ListUtils.isEqualList((Collection)((UserTO)((UserWrapper)UserWrapper.class.cast(modelObject)).getInnerObject()).getMemberships(), (Collection)((UserWrapper)UserWrapper.class.cast(modelObject)).getPreviousUserTO().getMemberships())) {
            groupsContainer.add(new Component[]{new LabelInfo("changed", "")});
        } else {
            groupsContainer.add(new Component[]{new Label("changed", (Serializable)((Object)""))});
        }
    }

    public boolean evaluate() {
        return (this.anyTO instanceof GroupTO ? !this.allDynRealms.isEmpty() : !this.allDynRealms.isEmpty() || !this.groupsModel.getObject().isEmpty()) && SyncopeConsoleApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER);
    }

    private class GroupsModel
    extends ListModel<GroupTO> {
        private static final long serialVersionUID = -4541954630939063927L;
        private List<GroupTO> groups;
        private List<MembershipTO> memberships;
        private List<String> dynMemberships;
        private String realm;

        private GroupsModel() {
        }

        public List<GroupTO> getObject() {
            this.reload();
            return this.groups;
        }

        private void reloadObject() {
            this.groups = Groups.this.groupRestClient.search(this.realm, SyncopeClient.getGroupSearchConditionBuilder().isAssignable().query(), 1, 30, (SortParam<String>)new SortParam((Object)"name", true), null);
        }

        public List<MembershipTO> getMemberships() {
            this.reload();
            return this.memberships;
        }

        private void reloadMemberships() {
            GroupFiqlSearchConditionBuilder searchConditionBuilder = SyncopeClient.getGroupSearchConditionBuilder();
            List conditions = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships().stream().map(membership -> searchConditionBuilder.is("key").equalTo(membership.getGroupKey(), new String[0]).wrap()).collect(Collectors.toList());
            HashMap assignedGroups = new HashMap();
            if (!conditions.isEmpty()) {
                assignedGroups.putAll(Groups.this.groupRestClient.search(this.realm, searchConditionBuilder.isAssignable().and().or(conditions).query(), -1, -1, (SortParam<String>)new SortParam((Object)"name", true), null).stream().collect(Collectors.toMap(AnyTO::getKey, Function.identity())));
            }
            ArrayList toBeRemoved = new ArrayList();
            ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships().forEach(membership -> {
                if (assignedGroups.containsKey(membership.getGroupKey())) {
                    membership.setGroupName(((GroupTO)assignedGroups.get(membership.getGroupKey())).getName());
                } else {
                    toBeRemoved.add(membership);
                }
            });
            ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships().removeAll(toBeRemoved);
            this.memberships = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getMemberships();
        }

        public List<String> getDynMemberships() {
            this.reload();
            return this.dynMemberships;
        }

        private void reloadDynMemberships() {
            GroupFiqlSearchConditionBuilder searchConditionBuilder = SyncopeClient.getGroupSearchConditionBuilder();
            List conditions = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(Groups.this.anyTO)).getDynMemberships().stream().map(membership -> searchConditionBuilder.is("key").equalTo(membership.getGroupKey(), new String[0]).wrap()).collect(Collectors.toList());
            this.dynMemberships = new ArrayList<String>();
            if (SyncopeConsoleSession.get().owns("GROUP_SEARCH", new String[0]) && !conditions.isEmpty()) {
                this.dynMemberships.addAll(Groups.this.groupRestClient.search("/", searchConditionBuilder.or(conditions).query(), -1, -1, (SortParam<String>)new SortParam((Object)"name", true), null).stream().map(GroupTO::getName).collect(Collectors.toList()));
            }
        }

        private void reload() {
            boolean reload;
            if (Groups.this.templateMode) {
                reload = this.realm == null;
                this.realm = "/";
            } else {
                reload = !Groups.this.anyTO.getRealm().equalsIgnoreCase(this.realm);
                this.realm = Groups.this.anyTO.getRealm();
            }
            if (reload) {
                this.reloadObject();
                this.reloadMemberships();
                this.reloadDynMemberships();
            }
        }
    }
}

