/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.pages.Realms;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.client.console.wizards.any.AnnotatedBeanPanel;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.to.AbstractAnnotatedBean;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Details<T extends AnyTO>
extends WizardStep {
    private static final long serialVersionUID = -8995647450549098844L;
    protected static final Logger LOG = LoggerFactory.getLogger(Details.class);
    protected final PageReference pageRef;
    private final FieldPanel<String> realm;

    public Details(AnyWrapper<T> wrapper, boolean templateMode, boolean includeStatusPanel, PageReference pageRef) {
        this.pageRef = pageRef;
        T inner = wrapper.getInnerObject();
        if (templateMode) {
            this.realm = new AjaxTextFieldPanel("destinationRealm", "destinationRealm", (IModel<String>)new PropertyModel(inner, "realm"), false);
            ((AjaxTextFieldPanel)AjaxTextFieldPanel.class.cast(this.realm)).enableJexlHelp();
        } else {
            List<RealmTO> realms = pageRef.getPage() instanceof Realms ? this.getRealmsFromLinks(((Realms)((Object)Realms.class.cast(pageRef.getPage()))).getRealmChoicePanel().getLinks()) : new RealmRestClient().list();
            this.realm = new AjaxDropDownChoicePanel<String>("destinationRealm", "destinationRealm", (IModel<String>)new PropertyModel(inner, "realm"), false);
            ((AjaxDropDownChoicePanel)this.realm).setChoices(realms.stream().map(RealmTO::getFullPath).collect(Collectors.toList()));
        }
        this.add(new Component[]{this.realm});
        this.add(new Component[]{this.getGeneralStatusInformation("generalStatusInformation", inner).setEnabled(includeStatusPanel).setVisible(includeStatusPanel).setRenderBodyOnly(true)});
    }

    public Details<T> disableRealmSpecification() {
        this.realm.setReadOnly(true);
        return this;
    }

    protected AnnotatedBeanPanel getGeneralStatusInformation(String id, T anyTO) {
        return new AnnotatedBeanPanel(id, (AbstractAnnotatedBean)anyTO);
    }

    private List<RealmTO> getRealmsFromLinks(List<AbstractLink> realmLinks) {
        ArrayList<RealmTO> realms = new ArrayList<RealmTO>();
        realmLinks.stream().map(link -> link.getDefaultModelObject()).filter(modelObject -> modelObject instanceof RealmTO).forEachOrdered(modelObject -> realms.add((RealmTO)modelObject));
        return realms;
    }
}

