/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import com.googlecode.wicket.kendo.ui.resource.KendoCultureResourceReference;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.springframework.util.StringUtils;

public class DateFieldPanel
extends FieldPanel<Date> {
    private static final long serialVersionUID = -428975732068281726L;
    protected final FastDateFormat fmt;

    protected DateFieldPanel(String id, String name, IModel<Date> model, String datePattern) {
        super(id, name, model);
        this.fmt = datePattern == null ? SyncopeConsoleSession.get().getDateFormat() : FastDateFormat.getInstance((String)datePattern);
    }

    @Override
    public FieldPanel<Date> setNewModel(final List<Serializable> list) {
        this.setNewModel(new Model<Date>(){
            private static final long serialVersionUID = 527651414610325237L;

            public Date getObject() {
                Date date = null;
                if (list != null && !list.isEmpty() && StringUtils.hasText((String)((Serializable)list.get(0)).toString())) {
                    try {
                        date = DateFieldPanel.this.fmt.parse(((Serializable)list.get(0)).toString());
                    }
                    catch (ParseException e) {
                        AbstractFieldPanel.LOG.error("invalid parse exception", (Throwable)e);
                    }
                }
                return date;
            }

            public void setObject(Date object) {
                list.clear();
                if (object != null) {
                    list.add(DateFieldPanel.this.fmt.format(object));
                }
            }
        });
        return this;
    }

    @Override
    public FieldPanel<Date> setNewModel(final ListItem item) {
        Model<Date> model = new Model<Date>(){
            private static final long serialVersionUID = 6799404673615637845L;

            public Date getObject() {
                Date date = null;
                Object obj = item.getModelObject();
                if (obj != null && !obj.toString().isEmpty()) {
                    if (obj instanceof String) {
                        try {
                            date = DateFieldPanel.this.fmt.parse(obj.toString());
                        }
                        catch (ParseException e) {
                            AbstractFieldPanel.LOG.error("While parsing date", (Throwable)e);
                        }
                    } else {
                        date = obj instanceof Date ? (Date)obj : new Date((Long)obj);
                    }
                }
                return date;
            }

            public void setObject(Date object) {
                item.setModelObject(object != null ? DateFieldPanel.this.fmt.format(object) : null);
            }
        };
        this.field.setModel((IModel)model);
        return this;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new KendoCultureResourceReference(SyncopeConsoleSession.get().getLocale())));
    }
}

