/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import java.io.Serializable;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class ActionLink<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 7031329706998320639L;
    private boolean reloadFeedbackPanel = true;
    private T modelObject;
    private boolean enabled = true;

    public ActionLink() {
    }

    public ActionLink(T modelObject) {
        this.modelObject = modelObject;
    }

    public T getModelObject() {
        return this.modelObject;
    }

    public abstract void onClick(AjaxRequestTarget var1, T var2);

    public void postClick() {
    }

    public boolean feedbackPanelAutomaticReload() {
        return this.reloadFeedbackPanel;
    }

    public ActionLink<T> feedbackPanelAutomaticReload(boolean reloadFeedbackPanel) {
        this.reloadFeedbackPanel = reloadFeedbackPanel;
        return this;
    }

    protected boolean statusCondition(T modelObject) {
        return true;
    }

    public Class<? extends Page> getPageClass() {
        return null;
    }

    public PageParameters getPageParameters() {
        return null;
    }

    public final ActionLink<T> disable() {
        this.enabled = false;
        return this;
    }

    public final boolean isEnabled(T modelObject) {
        return this.enabled && this.statusCondition(modelObject);
    }

    public boolean isIndicatorEnabled() {
        return true;
    }

    public static enum ActionType {
        MAPPING("update"),
        MUSTCHANGEPASSWORD("update"),
        SET_LATEST_SYNC_TOKEN("update"),
        REMOVE_SYNC_TOKEN("update"),
        CLONE("create"),
        CREATE("create"),
        TEMPLATE("read"),
        EDIT("read"),
        TYPE_EXTENSIONS("read"),
        FO_EDIT("read"),
        HTML("read"),
        TEXT("read"),
        COMPOSE("update"),
        LAYOUT_EDIT("read"),
        RESET("update"),
        ENABLE("update"),
        NOT_FOUND("read"),
        VIEW("view"),
        MEMBERS("members"),
        SEARCH("search"),
        DELETE("delete"),
        EXECUTE("execute"),
        PASSWORD_MANAGEMENT("update"),
        REQUEST_PASSWORD_RESET("update"),
        DRYRUN("execute"),
        CLAIM("claim"),
        UNCLAIM("unclaim"),
        SELECT("read"),
        CLOSE("read"),
        EXPORT("read"),
        EXPORT_CSV("read"),
        EXPORT_HTML("read"),
        EXPORT_PDF("read"),
        EXPORT_RTF("read"),
        EXPORT_XML("read"),
        RESTORE("import"),
        SUSPEND("update"),
        REACTIVATE("update"),
        RELOAD("import"),
        CHANGE_VIEW("changeView"),
        UNLINK("update"),
        LINK("update"),
        UNASSIGN("update"),
        ASSIGN("update"),
        DEPROVISION("update"),
        PROVISION("update"),
        DEPROVISION_MEMBERS("update"),
        PROVISION_MEMBERS("update"),
        RECONCILIATION_PUSH("update"),
        RECONCILIATION_PULL("update"),
        MANAGE_RESOURCES("update"),
        MANAGE_USERS("update"),
        MANAGE_GROUPS("update"),
        PROPAGATION_TASKS("read"),
        NOTIFICATION_TASKS("read"),
        ZOOM_IN("zoomin"),
        ZOOM_OUT("zoomout"),
        VIEW_EXECUTIONS("read"),
        VIEW_DETAILS("read"),
        MANAGE_APPROVAL("edit"),
        EDIT_APPROVAL("edit"),
        EXTERNAL_EDITOR("externalEditor");

        private final String actionId;

        private ActionType(String actionId) {
            this.actionId = actionId;
        }

        public String getActionId() {
            return this.actionId;
        }
    }
}

