/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.behavior.Draggable;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.behavior.DraggableConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.NotificationPanel;
import org.apache.syncope.client.console.panels.SubmitableModalPanel;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorModalCloseBehavior;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.buttons.DefaultModalCloseButton;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseModal<T extends Serializable>
extends Modal<T> {
    private static final long serialVersionUID = -6142277554912316095L;
    protected static final Logger LOG = LoggerFactory.getLogger(BaseModal.class);
    public static final String CONTENT_ID = "content";
    private static final String SUBMIT = "submit";
    private static final String FORM = "form";
    protected NotificationPanel notificationPanel;
    private final List<Component> components;
    private ModalWindow.WindowClosedCallback windowClosedCallback;
    private Panel content;
    private AjaxSubmitLink submitButton;
    private final Form<T> form = new Form("form");
    private final DefaultModalCloseButton defaultModalCloseButton;
    private AjaxEventBehavior closeBehavior;
    private WebMarkupContainer footer;

    public BaseModal(String id) {
        super(id);
        this.form.setOutputMarkupId(true);
        this.add(new Component[]{this.form});
        this.content = new AbstractModalPanel<T>(this, null){
            private static final long serialVersionUID = 1L;
        };
        this.content.setOutputMarkupId(true);
        this.form.add(new Component[]{this.content});
        this.useCloseHandler(true);
        this.windowClosedCallback = null;
        this.components = new ArrayList<Component>();
        this.add(new Behavior[]{new Draggable(new DraggableConfig().withHandle(".modal-header").withCursor("move"))});
        this.defaultModalCloseButton = new DefaultModalCloseButton();
        this.addButton((Component)this.defaultModalCloseButton);
        this.setUseKeyboard(true);
        this.setFadeIn(true);
    }

    public Form<T> getForm() {
        return this.form;
    }

    public BaseModal<T> setFormModel(T modelObject) {
        this.form.setModel((IModel)new CompoundPropertyModel(modelObject));
        return this;
    }

    public BaseModal<T> setFormModel(IModel<T> model) {
        this.form.setModel(model);
        return this;
    }

    public T getFormModel() {
        return (T)((Serializable)this.form.getModelObject());
    }

    public ModalPanel getContent() {
        if (this.content instanceof ModalPanel) {
            return (ModalPanel)this.content;
        }
        throw new IllegalStateException();
    }

    public BaseModal<T> setContent(ModalPanel component) {
        if (component instanceof Panel) {
            return this.setInternalContent((Panel)Panel.class.cast(component));
        }
        throw new IllegalArgumentException("Panel instance is required");
    }

    public BaseModal<T> setContent(ModalPanel component, AjaxRequestTarget target) {
        this.setContent(component);
        target.add(new Component[]{this.content});
        return this;
    }

    public BaseModal<T> changeCloseButtonLabel(String label) {
        this.defaultModalCloseButton.getModel().setObject((Object)label);
        return this;
    }

    public BaseModal<T> changeCloseButtonLabel(String label, AjaxRequestTarget target) {
        this.changeCloseButtonLabel(label);
        target.add(new Component[]{this.defaultModalCloseButton});
        return this;
    }

    private BaseModal<T> setInternalContent(Panel component) {
        if (!component.getId().equals(BaseModal.getContentId())) {
            throw new WicketRuntimeException("Modal content id is wrong. Component ID: " + component.getId() + "; content ID: " + BaseModal.getContentId());
        }
        this.content.replaceWith((Component)component);
        this.content = component;
        return this;
    }

    public static String getContentId() {
        return CONTENT_ID;
    }

    public BaseModal<T> setWindowClosedCallback(ModalWindow.WindowClosedCallback callback) {
        this.windowClosedCallback = callback;
        return this;
    }

    protected void onClose(IPartialPageRequestHandler target) {
        if (this.windowClosedCallback != null) {
            this.windowClosedCallback.onClose((AjaxRequestTarget)target);
        }
    }

    public AjaxSubmitLink addSubmitButton() {
        if (!(this.getContent() instanceof SubmitableModalPanel)) {
            throw new IllegalStateException();
        }
        AjaxSubmitLink submit = new AjaxSubmitLink(SUBMIT, this.form){
            private static final long serialVersionUID = -5783994974426198290L;

            protected void onSubmit(AjaxRequestTarget target) {
                ((SubmitableModalPanel)SubmitableModalPanel.class.cast(BaseModal.this.getContent())).onSubmit(target);
            }

            protected void onError(AjaxRequestTarget target) {
                ((SubmitableModalPanel)SubmitableModalPanel.class.cast(BaseModal.this.getContent())).onError(target);
            }
        };
        submit.setOutputMarkupId(true);
        if (this.submitButton == null) {
            this.submitButton = submit;
            this.components.add((Component)this.submitButton);
        } else {
            this.submitButton.replaceWith((Component)submit);
            this.submitButton = submit;
        }
        return submit;
    }

    public void removeSubmitButton() {
        if (!(this.getContent() instanceof SubmitableModalPanel)) {
            throw new IllegalStateException();
        }
        this.components.stream().filter(component -> SUBMIT.equals(component.getId())).findFirst().ifPresent(button -> this.components.remove(button));
        this.submitButton = null;
    }

    protected void onInitialize() {
        super.onInitialize();
        WebMarkupContainer dialog = (WebMarkupContainer)this.get("dialog");
        dialog.setMarkupId(this.getId());
        this.footer = (WebMarkupContainer)this.get("dialog:footer");
        this.footer.addOrReplace(new Component[]{new ListView<Component>("inputs", this.components){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<Component> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        }.setOutputMarkupId(true)}).setOutputMarkupId(true);
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ChangeFooterVisibilityEvent && this.footer != null) {
            AjaxRequestTarget target = ((ChangeFooterVisibilityEvent)ChangeFooterVisibilityEvent.class.cast(event.getPayload())).getTarget();
            target.add(new Component[]{this.footer.setEnabled(!this.footer.isEnabled())});
        }
    }

    public final Modal<T> useCloseHandler(boolean useCloseHandler) {
        if (useCloseHandler) {
            if (this.closeBehavior == null) {
                this.closeBehavior = new IndicatorModalCloseBehavior(){
                    private static final long serialVersionUID = -4955472558917915340L;

                    protected void onEvent(AjaxRequestTarget target) {
                        if (BaseModal.this.isVisible()) {
                            BaseModal.this.onClose((IPartialPageRequestHandler)target);
                            BaseModal.this.appendCloseDialogJavaScript((IPartialPageRequestHandler)target);
                        }
                    }
                };
                this.add(new Behavior[]{this.closeBehavior});
            }
        } else if (this.closeBehavior != null) {
            this.remove(new Behavior[]{this.closeBehavior});
            this.closeBehavior = null;
        }
        return this;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createInitializerScript(this.getMarkupId(true))));
    }

    private String createInitializerScript(String markupId) {
        return this.addCloseHandlerScript(markupId, this.createBasicInitializerScript(markupId));
    }

    private String addCloseHandlerScript(String markupId, String script) {
        if (this.closeBehavior != null) {
            return script + ";$('#" + markupId + "').on('hidden', function () {   Wicket.Ajax.ajax({'u':'" + this.closeBehavior.getCallbackUrl() + "','c':'" + markupId + "'});})";
        }
        return script;
    }

    public static class ChangeFooterVisibilityEvent
    extends ModalEvent {
        private static final long serialVersionUID = -6157576856659866343L;

        public ChangeFooterVisibilityEvent(AjaxRequestTarget target) {
            super(target);
        }
    }

    public static class ModalEvent
    implements Serializable {
        private static final long serialVersionUID = 2668922412196063559L;
        private final AjaxRequestTarget target;

        public ModalEvent(AjaxRequestTarget target) {
            this.target = target;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }
}

