/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.topology;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.ConfRestClient;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.topology.Topology;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.protocol.ws.api.WebSocketBehavior;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.message.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TopologyWebSocketBehavior
extends WebSocketBehavior {
    private static final long serialVersionUID = -1653665542635275551L;
    private static final Logger LOG = LoggerFactory.getLogger(TopologyWebSocketBehavior.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Map<String, String> resources = Collections.synchronizedMap(new HashMap());
    private static final String CONNECTOR_TEST_TIMEOUT_PARAMETER = "connector.test.timeout";
    private Integer connectorTestTimeout = null;
    private static final String RESOURCE_TEST_TIMEOUT_PARAMETER = "resource.test.timeout";
    private Integer resourceTestTimeout = null;
    private final Set<String> runningResCheck = Collections.synchronizedSet(new HashSet());
    private final Map<String, String> connectors = Collections.synchronizedMap(new HashMap());
    private final Set<String> runningConnCheck = Collections.synchronizedSet(new HashSet());
    private final ConnectorRestClient connectorRestClient = new ConnectorRestClient();
    private final ResourceRestClient resourceRestClient = new ResourceRestClient();

    public TopologyWebSocketBehavior() {
        try {
            for (AttrTO param : new ConfRestClient().list()) {
                if (CollectionUtils.isEmpty((Collection)param.getValues())) continue;
                try {
                    if (CONNECTOR_TEST_TIMEOUT_PARAMETER.equalsIgnoreCase(param.getSchema())) {
                        this.connectorTestTimeout = Integer.parseInt((String)param.getValues().get(0));
                        continue;
                    }
                    if (!RESOURCE_TEST_TIMEOUT_PARAMETER.equalsIgnoreCase(param.getSchema())) continue;
                    this.resourceTestTimeout = Integer.parseInt((String)param.getValues().get(0));
                }
                catch (NumberFormatException e) {
                    LOG.warn("Invalid timeout {}", (Object)param);
                }
            }
        }
        catch (SyncopeClientException syncopeClientException) {
            // empty catch block
        }
    }

    protected void onMessage(WebSocketRequestHandler handler, TextMessage message) {
        try {
            JsonNode obj = OBJECT_MAPPER.readTree(message.getText());
            switch (Topology.SupportedOperation.valueOf(obj.get("kind").asText())) {
                case CHECK_CONNECTOR: {
                    String ckey = obj.get("target").asText();
                    if (this.connectors.containsKey(ckey)) {
                        handler.push((CharSequence)this.connectors.get(ckey));
                    } else {
                        handler.push((CharSequence)String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.UNKNOWN, ckey}));
                    }
                    if (this.runningConnCheck.contains(ckey)) {
                        LOG.debug("Running connection check for connector {}", (Object)ckey);
                    } else {
                        this.runningConnCheck.add(ckey);
                    }
                    try {
                        SyncopeConsoleSession.get().execute(new ConnCheck(ckey));
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected error", (Throwable)e);
                    }
                    break;
                }
                case CHECK_RESOURCE: {
                    String rkey = obj.get("target").asText();
                    if (this.resources.containsKey(rkey)) {
                        handler.push((CharSequence)this.resources.get(rkey));
                    } else {
                        handler.push((CharSequence)String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.UNKNOWN, rkey}));
                    }
                    if (this.runningResCheck.contains(rkey)) {
                        LOG.debug("Running connection check for resource {}", (Object)rkey);
                    } else {
                        this.runningResCheck.add(rkey);
                    }
                    try {
                        SyncopeConsoleSession.get().execute(new ResCheck(rkey));
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected error", (Throwable)e);
                    }
                    break;
                }
                case ADD_ENDPOINT: {
                    handler.appendJavaScript((CharSequence)String.format("addEndpoint('%s', '%s', '%s');", obj.get("source").asText(), obj.get("target").asText(), obj.get("scope").asText()));
                    break;
                }
            }
        }
        catch (IOException e) {
            LOG.error("Eror managing websocket message", (Throwable)e);
        }
    }

    public boolean connCheckDone(Collection<String> connectors) {
        return this.connectors.keySet().containsAll(connectors);
    }

    public boolean resCheckDone(Collection<String> resources) {
        return this.resources.keySet().containsAll(resources);
    }

    private void timeoutHandlingConnectionChecker(Checker checker, Integer timeout, Map<String, String> responses, Set<String> running) {
        String res = null;
        try {
            if (timeout == null) {
                LOG.debug("No timeouts for resource connection checking ... ");
                res = SyncopeConsoleSession.get().execute(checker).get();
            } else if (timeout > 0) {
                LOG.debug("Timeouts provided for resource connection checking ... ");
                res = SyncopeConsoleSession.get().execute(checker).get(timeout.intValue(), TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.warn("Connection with {} timed out", (Object)checker.getKey());
            res = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.UNREACHABLE, checker.getKey()});
        }
        catch (Exception e) {
            LOG.error("Unexpected exception conneting to {}", (Object)checker.getKey(), (Object)e);
            res = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.FAILURE, checker.getKey()});
        }
        if (res != null) {
            responses.put(checker.getKey(), res);
        }
        running.remove(checker.getKey());
    }

    class ResourceChecker
    extends Checker {
        ResourceChecker(String key, Application application) {
            super(key, application);
        }

        @Override
        public String call() throws Exception {
            ThreadContext.setApplication((Application)this.application);
            ThreadContext.setSession((Session)this.session);
            try {
                ResourceTO resource = TopologyWebSocketBehavior.this.resourceRestClient.read(this.key);
                String string = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{(Boolean)TopologyWebSocketBehavior.this.resourceRestClient.check(resource).getLeft() != false ? TopologyNode.Status.REACHABLE : TopologyNode.Status.UNREACHABLE, this.key});
                return string;
            }
            catch (Exception e) {
                LOG.warn("Error checking connection for {}", (Object)this.key, (Object)e);
                String string = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.FAILURE, this.key});
                return string;
            }
            finally {
                ThreadContext.detach();
            }
        }
    }

    class ConnectorChecker
    extends Checker {
        ConnectorChecker(String key, Application application) {
            super(key, application);
        }

        @Override
        public String call() throws Exception {
            ThreadContext.setApplication((Application)this.application);
            ThreadContext.setSession((Session)this.session);
            try {
                ConnInstanceTO connector = TopologyWebSocketBehavior.this.connectorRestClient.read(this.key);
                String string = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{(Boolean)TopologyWebSocketBehavior.this.connectorRestClient.check(connector).getLeft() != false ? TopologyNode.Status.REACHABLE : TopologyNode.Status.UNREACHABLE, this.key});
                return string;
            }
            catch (Exception e) {
                LOG.warn("Error checking connection for {}", (Object)this.key, (Object)e);
                String string = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.FAILURE, this.key});
                return string;
            }
            finally {
                ThreadContext.detach();
            }
        }
    }

    abstract class Checker
    implements Callable<String> {
        protected final String key;
        protected final Application application;
        protected final Session session;

        Checker(String key, Application application) {
            this.key = key;
            this.application = application;
            this.session = Session.exists() ? Session.get() : null;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public abstract String call() throws Exception;
    }

    class ResCheck
    implements Runnable {
        private final String key;
        private final Application application;
        private final Session session;

        ResCheck(String key) {
            this.key = key;
            this.application = Application.get();
            this.session = Session.exists() ? Session.get() : null;
        }

        @Override
        public void run() {
            ThreadContext.setApplication((Application)this.application);
            ThreadContext.setSession((Session)this.session);
            try {
                TopologyWebSocketBehavior.this.timeoutHandlingConnectionChecker(new ResourceChecker(this.key, this.application), TopologyWebSocketBehavior.this.resourceTestTimeout, TopologyWebSocketBehavior.this.resources, TopologyWebSocketBehavior.this.runningResCheck);
            }
            finally {
                ThreadContext.detach();
            }
        }
    }

    class ConnCheck
    implements Runnable {
        private final String key;
        private final Application application;
        private final Session session;

        ConnCheck(String key) {
            this.key = key;
            this.application = Application.get();
            this.session = Session.exists() ? Session.get() : null;
        }

        @Override
        public void run() {
            ThreadContext.setApplication((Application)this.application);
            ThreadContext.setSession((Session)this.session);
            try {
                TopologyWebSocketBehavior.this.timeoutHandlingConnectionChecker(new ConnectorChecker(this.key, this.application), TopologyWebSocketBehavior.this.connectorTestTimeout, TopologyWebSocketBehavior.this.connectors, TopologyWebSocketBehavior.this.runningConnCheck);
            }
            finally {
                ThreadContext.detach();
            }
        }
    }
}

