/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.log.EventCategory;
import org.apache.syncope.common.lib.log.LogAppender;
import org.apache.syncope.common.lib.log.LogStatement;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.syncope.common.lib.types.LoggerType;
import org.apache.syncope.common.rest.api.LoggerWrapper;
import org.apache.syncope.common.rest.api.service.LoggerService;

public class LoggerRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 4579786978763032240L;

    public List<String> listMemoryAppenders() {
        return LoggerRestClient.getService(LoggerService.class).memoryAppenders().stream().map(LogAppender::getName).collect(Collectors.toList());
    }

    public List<LogStatement> getLastLogStatements(String appender, long lastStatementTime) {
        ArrayList<LogStatement> result = new ArrayList<LogStatement>();
        LoggerRestClient.getService(LoggerService.class).getLastLogStatements(appender).stream().filter(statement -> statement.getTimeMillis() > lastStatementTime).forEachOrdered(statement -> result.add((LogStatement)statement));
        return result;
    }

    public List<LoggerTO> listLogs() {
        List logs = LoggerRestClient.getService(LoggerService.class).list(LoggerType.LOG);
        Collections.sort(logs, (o1, o2) -> ObjectUtils.compare((Comparable)((Object)o1.getKey()), (Comparable)((Object)o2.getKey())));
        return logs;
    }

    public List<AuditLoggerName> listAudits() {
        return LoggerWrapper.wrap((Collection)LoggerRestClient.getService(LoggerService.class).list(LoggerType.AUDIT));
    }

    public Map<String, Set<AuditLoggerName>> listAuditsByCategory() {
        HashMap<String, Set<AuditLoggerName>> result = new HashMap<String, Set<AuditLoggerName>>();
        this.listAudits().forEach(audit -> {
            if (!result.containsKey(audit.getCategory())) {
                result.put(audit.getCategory(), new HashSet());
            }
            ((Set)result.get(audit.getCategory())).add(audit);
        });
        return result;
    }

    public void setLogLevel(LoggerTO loggerTO) {
        LoggerRestClient.getService(LoggerService.class).update(LoggerType.LOG, loggerTO);
    }

    public void enableAudit(AuditLoggerName auditLoggerName) {
        LoggerTO loggerTO = new LoggerTO();
        loggerTO.setKey(auditLoggerName.toLoggerName());
        loggerTO.setLevel(LoggerLevel.DEBUG);
        LoggerRestClient.getService(LoggerService.class).update(LoggerType.AUDIT, loggerTO);
    }

    public void deleteLog(String name) {
        LoggerRestClient.getService(LoggerService.class).delete(LoggerType.LOG, name);
    }

    public void disableAudit(AuditLoggerName auditLoggerName) {
        LoggerRestClient.getService(LoggerService.class).delete(LoggerType.AUDIT, auditLoggerName.toLoggerName());
    }

    public List<EventCategory> listEvents() {
        try {
            return LoggerRestClient.getService(LoggerService.class).events();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

