/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import org.apache.syncope.client.console.panels.ParametersCreateWizardAttrStep;
import org.apache.syncope.client.console.panels.ParametersCreateWizardSchemaStep;
import org.apache.syncope.client.console.rest.ConfRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;

public class ParametersCreateWizardPanel
extends AjaxWizardBuilder<ParametersForm> {
    private static final long serialVersionUID = -2868592590785581481L;
    private final ConfRestClient confRestClient = new ConfRestClient();
    private final SchemaRestClient schemaRestClient = new SchemaRestClient();

    public ParametersCreateWizardPanel(ParametersForm defaultItem, PageReference pageRef) {
        super(defaultItem, pageRef);
    }

    @Override
    protected WizardModel buildModelSteps(ParametersForm modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new ParametersCreateWizardSchemaStep(modelObject));
        wizardModel.add((IWizardStep)new ParametersCreateWizardAttrStep(modelObject));
        return wizardModel;
    }

    @Override
    protected void onCancelInternal(ParametersForm modelObject) {
    }

    @Override
    protected Serializable onApplyInternal(ParametersForm modelObject) {
        PlainSchemaTO plainSchemaTO = modelObject.getPlainSchemaTO();
        plainSchemaTO.setKey(modelObject.getAttrTO().getSchema());
        this.schemaRestClient.create(SchemaType.PLAIN, (SchemaTO)plainSchemaTO);
        try {
            this.confRestClient.set(modelObject.getAttrTO());
        }
        catch (Exception e) {
            LOG.error("While setting {}, removing {}", new Object[]{modelObject.getAttrTO(), plainSchemaTO, e});
            this.schemaRestClient.deletePlainSchema(plainSchemaTO.getKey());
            throw e;
        }
        return modelObject.getAttrTO();
    }

    public static class ParametersForm
    implements Serializable {
        private static final long serialVersionUID = 412294016850871853L;
        private final PlainSchemaTO plainSchemaTO = new PlainSchemaTO();
        private final AttrTO attrTO = new AttrTO();

        public PlainSchemaTO getPlainSchemaTO() {
            return this.plainSchemaTO;
        }

        public AttrTO getAttrTO() {
            return this.attrTO;
        }
    }
}

