/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.kendo.ui.widget.notification.Notification;
import java.util.List;
import org.apache.syncope.client.console.commons.StyledNotificationBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class NotificationPanel
extends Panel
implements IFeedback,
IGenericComponent<List<FeedbackMessage>, NotificationPanel> {
    private static final long serialVersionUID = 5895940553202128621L;
    private final Notification notification;

    public NotificationPanel(String id) {
        super(id);
        Options options = new Options();
        options.set("appendTo", (Object)"'#appendto'");
        options.set("stacking", (Object)"'up'");
        options.set("templates", (Object)"[ { type: 'success', template: $('#successTemplate').html() }, { type: 'info', template: $('#successTemplate').html() }, { type: 'error', template: $('#errorTemplate').html() }, { type: 'warning', template: $('#warningTemplate').html() } ] ");
        this.notification = new Notification("feedback", options){
            private static final long serialVersionUID = 785830249476640904L;

            public StyledNotificationBehavior newWidgetBehavior(String selector) {
                return new StyledNotificationBehavior(selector, this.options);
            }
        };
        this.add(new Component[]{this.notification});
    }

    public final void refresh(IPartialPageRequestHandler handler) {
        this.getModelObject().forEach(message -> {
            if (message.isError()) {
                this.notification.error(handler, message.getMessage());
            } else if (message.isWarning()) {
                this.notification.warn(handler, message.getMessage());
            } else if (message.isSuccess() || message.isInfo()) {
                this.notification.success(handler, message.getMessage());
            } else {
                this.notification.warn(handler, message.getMessage());
            }
            message.markRendered();
        });
    }

    protected IModel<?> initModel() {
        return new FeedbackMessagesModel((Component)this);
    }

    public IModel<List<FeedbackMessage>> getModel() {
        return this.getDefaultModel();
    }

    public NotificationPanel setModel(IModel<List<FeedbackMessage>> model) {
        this.setDefaultModel(model);
        return this;
    }

    public NotificationPanel setModelObject(List<FeedbackMessage> object) {
        this.setDefaultModelObject(object);
        return this;
    }

    public List<FeedbackMessage> getModelObject() {
        return (List)this.getDefaultModelObject();
    }
}

