/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonDiffPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.JsonEditorPanel;
import org.apache.syncope.common.lib.to.AbstractHistoryConf;
import org.apache.syncope.common.lib.to.ConnInstanceHistoryConfTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ResourceHistoryConfTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class HistoryConfDetails<T extends AbstractHistoryConf>
extends MultilevelPanel.SecondLevel {
    private static final long serialVersionUID = -7400543686272100483L;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final T selectedHistoryConfTO;
    private final List<T> availableHistoryConfTOs;
    private AbstractModalPanel<String> jsonPanel;

    public HistoryConfDetails(BaseModal<?> baseModal, T selectedHistoryConfTO, PageReference pageRef, List<T> availableHistoryConfTOs) {
        this.availableHistoryConfTOs = availableHistoryConfTOs.stream().filter(object -> object.getKey().equals(selectedHistoryConfTO.getKey())).collect(Collectors.toList());
        this.selectedHistoryConfTO = selectedHistoryConfTO;
        this.addCurrentInstanceConf();
        Form<?> form = this.initDropdownDiffConfForm();
        this.add(new Component[]{form});
        form.setVisible(!availableHistoryConfTOs.isEmpty());
        this.showConfigurationSinglePanel();
    }

    private void showConfigurationSinglePanel() {
        Pair<String, String> info = this.getJSONInfo(this.selectedHistoryConfTO);
        this.jsonPanel = new JsonEditorPanel(null, (IModel)new PropertyModel(info, "right"), true, null){
            private static final long serialVersionUID = -8927036362466990179L;

            @Override
            public void onSubmit(AjaxRequestTarget target) {
                this.modal.close((IPartialPageRequestHandler)target);
            }
        };
        this.jsonPanel.setOutputMarkupId(true);
        this.addOrReplace(new Component[]{this.jsonPanel});
    }

    private void showConfigurationDiffPanel(List<T> historyConfTOs) {
        ArrayList infos = new ArrayList();
        historyConfTOs.forEach(historyConfTO -> infos.add(this.getJSONInfo(historyConfTO)));
        this.jsonPanel = new JsonDiffPanel(null, (IModel)new PropertyModel(infos.get(0), "value"), (IModel)new PropertyModel(infos.get(1), "value"), null){
            private static final long serialVersionUID = -8927036362466990179L;

            @Override
            public void onSubmit(AjaxRequestTarget target) {
                this.modal.close((IPartialPageRequestHandler)target);
            }
        };
        this.replace((Component)this.jsonPanel);
    }

    private Pair<String, String> getJSONInfo(T historyConfTO) {
        ConnInstanceHistoryConfTO historyConf;
        ConnInstanceTO conf = null;
        String key = "";
        if (historyConfTO instanceof ConnInstanceHistoryConfTO) {
            historyConf = (ConnInstanceHistoryConfTO)ConnInstanceHistoryConfTO.class.cast(historyConfTO);
            conf = historyConf.getConnInstanceTO();
            key = historyConf.getKey();
        } else if (historyConfTO instanceof ResourceHistoryConfTO) {
            historyConf = (ResourceHistoryConfTO)ResourceHistoryConfTO.class.cast(historyConfTO);
            conf = historyConf.getResourceTO();
            key = historyConf.getKey();
        }
        String json = "";
        try {
            json = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)conf);
        }
        catch (IOException ex) {
            DirectoryPanel.LOG.error("Error converting objects to JSON", (Throwable)ex);
        }
        return Pair.of((Object)key, (Object)json);
    }

    private <T extends AbstractHistoryConf> Map<String, String> getDropdownNamesMap(List<T> historyConfTOs) {
        LinkedHashMap<String, String> historyConfMap = new LinkedHashMap<String, String>();
        String current = null;
        for (AbstractHistoryConf historyConf : historyConfTOs) {
            if (historyConf.getCreation() == null) {
                current = historyConf.getKey();
                continue;
            }
            historyConfMap.put(historyConf.getKey(), historyConf.getCreator() + " - " + SyncopeConsoleSession.get().getDateFormat().format(historyConf.getCreation()) + " - " + historyConf.getKey());
        }
        if (current != null) {
            historyConfMap.put(current, this.getString("current"));
        }
        return historyConfMap;
    }

    private Form<?> initDropdownDiffConfForm() {
        Form form = new Form("form");
        form.setModel((IModel)new CompoundPropertyModel(this.selectedHistoryConfTO));
        form.setOutputMarkupId(true);
        final Map<String, String> namesMap = this.getDropdownNamesMap(this.availableHistoryConfTOs);
        ArrayList<String> keys = new ArrayList<String>(namesMap.keySet());
        final AjaxDropDownChoicePanel<String> dropdownElem = new AjaxDropDownChoicePanel<String>("compareDropdown", this.getString("compare"), (IModel<String>)new PropertyModel(this.selectedHistoryConfTO, "key"), false);
        dropdownElem.setChoices(keys);
        dropdownElem.setChoiceRenderer(new IChoiceRenderer<String>(){
            private static final long serialVersionUID = -6265603675261014912L;

            public Object getDisplayValue(String value) {
                return namesMap.get(value) == null ? value : namesMap.get(value);
            }

            public String getIdValue(String value, int i) {
                return value;
            }

            public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                return id;
            }
        });
        dropdownElem.setNullValid(true);
        dropdownElem.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ArrayList<AbstractHistoryConf> elemsToCompare = new ArrayList<AbstractHistoryConf>();
                elemsToCompare.add(HistoryConfDetails.this.selectedHistoryConfTO);
                String selectedKey = (String)dropdownElem.getModelObject();
                if (selectedKey != null) {
                    if (!selectedKey.isEmpty()) {
                        AbstractHistoryConf confToCompare = HistoryConfDetails.this.availableHistoryConfTOs.stream().filter(object -> object.getKey().equals(selectedKey)).findAny().orElse(null);
                        elemsToCompare.add(confToCompare);
                        HistoryConfDetails.this.showConfigurationDiffPanel(elemsToCompare);
                    } else {
                        HistoryConfDetails.this.showConfigurationSinglePanel();
                    }
                }
                target.add(new Component[]{HistoryConfDetails.this.jsonPanel});
            }
        }});
        form.add(new Component[]{dropdownElem});
        return form;
    }

    private void addCurrentInstanceConf() {
        ConnInstanceHistoryConfTO conf = null;
        if (this.selectedHistoryConfTO instanceof ConnInstanceHistoryConfTO) {
            ConnInstanceTO current = new ConnectorRestClient().read(((ConnInstanceHistoryConfTO)ConnInstanceHistoryConfTO.class.cast(this.selectedHistoryConfTO)).getConnInstanceTO().getKey());
            conf = new ConnInstanceHistoryConfTO();
            conf.setConnInstanceTO(current);
        } else if (this.selectedHistoryConfTO instanceof ResourceHistoryConfTO) {
            ResourceTO current = new ResourceRestClient().read(((ResourceHistoryConfTO)ResourceHistoryConfTO.class.cast(this.selectedHistoryConfTO)).getResourceTO().getKey());
            conf = new ResourceHistoryConfTO();
            ((ResourceHistoryConfTO)conf).setResourceTO(current);
        }
        if (conf != null) {
            conf.setCreator(this.selectedHistoryConfTO.getCreator());
            conf.setKey("current");
            this.availableHistoryConfTOs.add(conf);
        }
    }
}

