/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.syncope.client.console.panels.AbstractLogsPanel;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.wicket.PageReference;

public class ConsoleLogPanel
extends AbstractLogsPanel<LoggerTO> {
    private static final long serialVersionUID = -9165749229623482717L;
    private static final ConsoleLoggerController CONSOLE_LOGGER_CONTROLLER = new ConsoleLoggerController();

    public ConsoleLogPanel(String id, PageReference pageReference) {
        super(id, pageReference, CONSOLE_LOGGER_CONTROLLER.getLoggers());
    }

    @Override
    protected void update(LoggerTO loggerTO) {
        CONSOLE_LOGGER_CONTROLLER.setLogLevel(loggerTO.getKey(), loggerTO.getLevel());
    }

    private static class ConsoleLoggerController
    implements Serializable {
        private static final long serialVersionUID = -1550459341476431714L;

        private ConsoleLoggerController() {
        }

        public List<LoggerTO> getLoggers() {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            ArrayList<LoggerTO> result = new ArrayList<LoggerTO>();
            ctx.getConfiguration().getLoggers().values().forEach(logger -> {
                String loggerName;
                String string = loggerName = "".equals(logger.getName()) ? "ROOT" : logger.getName();
                if (logger.getLevel() != null) {
                    LoggerTO loggerTO = new LoggerTO();
                    loggerTO.setKey(loggerName);
                    loggerTO.setLevel(LoggerLevel.fromLevel((Level)logger.getLevel()));
                    result.add(loggerTO);
                }
            });
            Collections.sort(result, (o1, o2) -> ObjectUtils.compare((Comparable)((Object)o1.getKey()), (Comparable)((Object)o2.getKey())));
            return result;
        }

        public void setLogLevel(String name, LoggerLevel level) {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            LoggerConfig logConf = "ROOT".equals(name) ? ctx.getConfiguration().getLoggerConfig("") : ctx.getConfiguration().getLoggerConfig(name);
            logConf.setLevel(level.getLevel());
            ctx.updateLoggers();
        }
    }
}

