/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.Collapsible;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.client.console.layout.AbstractAnyFormLayout;
import org.apache.syncope.client.console.layout.AnyObjectFormLayoutInfo;
import org.apache.syncope.client.console.layout.FormLayoutInfoUtils;
import org.apache.syncope.client.console.layout.GroupFormLayoutInfo;
import org.apache.syncope.client.console.layout.UserFormLayoutInfo;
import org.apache.syncope.client.console.panels.AnyObjectDirectoryPanel;
import org.apache.syncope.client.console.panels.GroupDirectoryPanel;
import org.apache.syncope.client.console.panels.LabelPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.UserDirectoryPanel;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.GroupSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyPanel
extends Panel
implements ModalPanel {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final Logger LOG = LoggerFactory.getLogger(AnyPanel.class);
    private final AnyTypeTO anyTypeTO;
    private final RealmTO realmTO;
    private final AnyTypeClassRestClient anyTypeClassRestClient = new AnyTypeClassRestClient();
    private final Triple<UserFormLayoutInfo, GroupFormLayoutInfo, Map<String, AnyObjectFormLayoutInfo>> formLayoutInfo;
    private final PageReference pageRef;
    private AbstractSearchPanel searchPanel;
    private final Panel directoryPanel;

    public AnyPanel(String id, AnyTypeTO anyTypeTO, RealmTO realmTO, Triple<UserFormLayoutInfo, GroupFormLayoutInfo, Map<String, AnyObjectFormLayoutInfo>> formLayoutInfo, boolean enableSearch, PageReference pageRef) {
        super(id);
        this.anyTypeTO = anyTypeTO;
        this.realmTO = realmTO;
        this.formLayoutInfo = formLayoutInfo;
        this.pageRef = pageRef;
        final Model model = Model.of((Serializable)Integer.valueOf(-1));
        final StringResourceModel res = new StringResourceModel("search.result", (Component)this, (IModel)new Model((Serializable)anyTypeTO));
        Accordion accordion = new Accordion("accordionPanel", Collections.singletonList(new AbstractTab((IModel)res){
            private static final long serialVersionUID = 1037272333056449377L;

            public WebMarkupContainer getPanel(String panelId) {
                AnyPanel.this.searchPanel = AnyPanel.this.getSearchPanel(panelId);
                return AnyPanel.this.searchPanel;
            }
        }), (IModel)model){
            private static final long serialVersionUID = 1L;

            protected Component newTitle(String markupId, ITab tab, Collapsible.State state) {
                return new AjaxLink<Integer>(markupId){
                    private static final long serialVersionUID = 1L;

                    protected void onComponentTag(ComponentTag tag) {
                        super.onComponentTag(tag);
                        tag.put("style", (CharSequence)"color: #337ab7");
                    }

                    public void onClick(AjaxRequestTarget target) {
                        model.setObject((Serializable)Integer.valueOf((Integer)model.getObject() == 0 ? -1 : 0));
                    }
                }.setBody((IModel)res);
            }
        };
        accordion.setOutputMarkupId(true);
        this.add(new Component[]{accordion.setEnabled(enableSearch).setVisible(enableSearch)});
        this.directoryPanel = this.getDirectoryPanel("searchResult");
        this.add(new Component[]{this.directoryPanel});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof SearchClausePanel.SearchEvent) {
            AjaxRequestTarget target = ((SearchClausePanel.SearchEvent)SearchClausePanel.SearchEvent.class.cast(event.getPayload())).getTarget();
            String precond = this.realmTO.getFullPath().startsWith("/") ? "" : String.format("$dynRealms=~%s;", this.realmTO.getKey());
            switch (this.anyTypeTO.getKind()) {
                case USER: {
                    ((UserDirectoryPanel)((Object)UserDirectoryPanel.class.cast(this.directoryPanel))).search(precond + SearchUtils.buildFIQL((List)this.searchPanel.getModel().getObject(), (AbstractFiqlSearchConditionBuilder)SyncopeClient.getUserSearchConditionBuilder(), this.searchPanel.getAvailableSchemaTypes()), target);
                    break;
                }
                case GROUP: {
                    ((GroupDirectoryPanel)((Object)GroupDirectoryPanel.class.cast(this.directoryPanel))).search(precond + SearchUtils.buildFIQL((List)this.searchPanel.getModel().getObject(), (AbstractFiqlSearchConditionBuilder)SyncopeClient.getGroupSearchConditionBuilder(), this.searchPanel.getAvailableSchemaTypes()), target);
                    break;
                }
                case ANY_OBJECT: {
                    ((AnyObjectDirectoryPanel)((Object)AnyObjectDirectoryPanel.class.cast(this.directoryPanel))).search(precond + SearchUtils.buildFIQL((List)this.searchPanel.getModel().getObject(), (AbstractFiqlSearchConditionBuilder)SyncopeClient.getAnyObjectSearchConditionBuilder((String)this.anyTypeTO.getKey()), this.searchPanel.getAvailableSchemaTypes()), target);
                    break;
                }
            }
        } else {
            super.onEvent(event);
        }
    }

    private AbstractSearchPanel getSearchPanel(String id) {
        AbstractSearchPanel panel;
        ArrayList<SearchClause> clauses = new ArrayList<SearchClause>();
        SearchClause clause = new SearchClause();
        clauses.add(clause);
        switch (this.anyTypeTO.getKind()) {
            case USER: {
                clause.setComparator(SearchClause.Comparator.EQUALS);
                clause.setType(SearchClause.Type.ATTRIBUTE);
                clause.setProperty("username");
                panel = (AbstractSearchPanel)((Object)new UserSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses)).required(true).enableSearch().build(id));
                break;
            }
            case GROUP: {
                clause.setComparator(SearchClause.Comparator.EQUALS);
                clause.setType(SearchClause.Type.ATTRIBUTE);
                clause.setProperty("name");
                panel = (AbstractSearchPanel)((Object)new GroupSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(clauses)).required(true).enableSearch().build(id));
                break;
            }
            case ANY_OBJECT: {
                clause.setComparator(SearchClause.Comparator.EQUALS);
                clause.setType(SearchClause.Type.ATTRIBUTE);
                clause.setProperty("name");
                panel = (AbstractSearchPanel)((Object)new AnyObjectSearchPanel.Builder(this.anyTypeTO.getKey(), (IModel<List<SearchClause>>)new ListModel(clauses)).required(true).enableSearch().build(id));
                break;
            }
            default: {
                panel = null;
            }
        }
        return panel;
    }

    protected Panel getDirectoryPanel(String id) {
        WizardMgtPanel panel;
        String dynRealm;
        String realm;
        if (this.realmTO.getFullPath().startsWith("/")) {
            realm = this.realmTO.getFullPath();
            dynRealm = null;
        } else {
            realm = "/";
            dynRealm = this.realmTO.getKey();
        }
        switch (this.anyTypeTO.getKind()) {
            case USER: {
                String fiql = dynRealm == null ? SyncopeClient.getUserSearchConditionBuilder().is("key").notNullValue().query() : SyncopeClient.getUserSearchConditionBuilder().inDynRealms(dynRealm, new String[0]).query();
                UserTO userTO = new UserTO();
                userTO.setRealm(this.realmTO.getFullPath());
                panel = new UserDirectoryPanel.Builder(this.anyTypeClassRestClient.list(this.anyTypeTO.getClasses()), this.anyTypeTO.getKey(), this.pageRef).setRealm(realm).setDynRealm(dynRealm).setFiltered(true).setFiql(fiql).setWizardInModal(true).addNewItemPanelBuilder(FormLayoutInfoUtils.instantiate(userTO, this.anyTypeTO.getClasses(), (AbstractAnyFormLayout)this.formLayoutInfo.getLeft(), this.pageRef)).build(id);
                MetaDataRoleAuthorizationStrategy.authorize(panel, (Action)WebPage.RENDER, (String)"USER_SEARCH");
                break;
            }
            case GROUP: {
                String fiql = dynRealm == null ? SyncopeClient.getGroupSearchConditionBuilder().is("key").notNullValue().query() : SyncopeClient.getGroupSearchConditionBuilder().inDynRealms(dynRealm, new String[0]).query();
                GroupTO groupTO = new GroupTO();
                groupTO.setRealm(this.realmTO.getFullPath());
                panel = new GroupDirectoryPanel.Builder(this.anyTypeClassRestClient.list(this.anyTypeTO.getClasses()), this.anyTypeTO.getKey(), this.pageRef).setRealm(realm).setDynRealm(dynRealm).setFiltered(true).setFiql(fiql).setWizardInModal(true).addNewItemPanelBuilder(FormLayoutInfoUtils.instantiate(groupTO, this.anyTypeTO.getClasses(), (AbstractAnyFormLayout)this.formLayoutInfo.getMiddle(), this.pageRef)).build(id);
                break;
            }
            case ANY_OBJECT: {
                String fiql = dynRealm == null ? SyncopeClient.getAnyObjectSearchConditionBuilder((String)this.anyTypeTO.getKey()).is("key").notNullValue().query() : SyncopeClient.getAnyObjectSearchConditionBuilder((String)this.anyTypeTO.getKey()).inDynRealms(dynRealm, new String[0]).query();
                AnyObjectTO anyObjectTO = new AnyObjectTO();
                anyObjectTO.setRealm(this.realmTO.getFullPath());
                anyObjectTO.setType(this.anyTypeTO.getKey());
                panel = new AnyObjectDirectoryPanel.Builder(this.anyTypeClassRestClient.list(this.anyTypeTO.getClasses()), this.anyTypeTO.getKey(), this.pageRef).setRealm(realm).setDynRealm(dynRealm).setFiltered(true).setFiql(fiql).setWizardInModal(true).addNewItemPanelBuilder(FormLayoutInfoUtils.instantiate(anyObjectTO, this.anyTypeTO.getClasses(), (AbstractAnyFormLayout)((Map)this.formLayoutInfo.getRight()).get(this.anyTypeTO.getKey()), this.pageRef)).build(id);
                MetaDataRoleAuthorizationStrategy.authorize(panel, (Action)WebPage.RENDER, (String)AnyEntitlement.SEARCH.getFor(this.anyTypeTO.getKey()));
                break;
            }
            default: {
                panel = new LabelPanel(id, null);
            }
        }
        return panel;
    }
}

