/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.events.EventCategoryPanel;
import org.apache.syncope.client.console.events.SelectedEventsPanel;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.rest.LoggerRestClient;
import org.apache.syncope.common.lib.log.EventCategory;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.wicket.Component;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class Audit
extends BasePage {
    private static final long serialVersionUID = -1100228004207271271L;

    public Audit(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build("dashboard", "dashboardBr", Dashboard.class)});
        final LoggerRestClient loggerRestClient = new LoggerRestClient();
        List events = loggerRestClient.listAudits().stream().map(audit -> AuditLoggerName.buildEvent((AuditElements.EventCategoryType)audit.getType(), (String)audit.getCategory(), (String)audit.getSubcategory(), (String)audit.getEvent(), (AuditElements.Result)audit.getResult())).collect(Collectors.toList());
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        Form form = new Form("auditForm");
        content.add(new Component[]{form});
        form.add(new Component[]{new EventCategoryPanel("auditPanel", loggerRestClient.listEvents(), (IModel)new ListModel(events)){
            private static final long serialVersionUID = 6113164334533550277L;

            @Override
            protected List<String> getListAuthRoles() {
                return Collections.singletonList("AUDIT_LIST");
            }

            @Override
            protected List<String> getChangeAuthRoles() {
                return Arrays.asList("AUDIT_ENABLE", "AUDIT_DISABLE");
            }

            @Override
            public void onEventAction(IEvent<?> event) {
                if (event.getPayload() instanceof SelectedEventsPanel.EventSelectionChanged) {
                    SelectedEventsPanel.EventSelectionChanged eventSelectionChanged = (SelectedEventsPanel.EventSelectionChanged)event.getPayload();
                    eventSelectionChanged.getToBeRemoved().forEach(toBeRemoved -> {
                        Pair eventCategory = AuditLoggerName.parseEventCategory((String)toBeRemoved);
                        AuditLoggerName auditLoggerName = new AuditLoggerName(((EventCategory)eventCategory.getKey()).getType(), ((EventCategory)eventCategory.getKey()).getCategory(), ((EventCategory)eventCategory.getKey()).getSubcategory(), CollectionUtils.isEmpty((Collection)((EventCategory)eventCategory.getKey()).getEvents()) ? null : (String)((EventCategory)eventCategory.getKey()).getEvents().iterator().next(), (AuditElements.Result)eventCategory.getValue());
                        loggerRestClient.disableAudit(auditLoggerName);
                    });
                    eventSelectionChanged.getToBeAdded().forEach(toBeAdded -> {
                        Pair eventCategory = AuditLoggerName.parseEventCategory((String)toBeAdded);
                        AuditLoggerName auditLoggerName = new AuditLoggerName(((EventCategory)eventCategory.getKey()).getType(), ((EventCategory)eventCategory.getKey()).getCategory(), ((EventCategory)eventCategory.getKey()).getSubcategory(), CollectionUtils.isEmpty((Collection)((EventCategory)eventCategory.getKey()).getEvents()) ? null : (String)((EventCategory)eventCategory.getKey()).getEvents().iterator().next(), (AuditElements.Result)eventCategory.getValue());
                        loggerRestClient.enableAudit(auditLoggerName);
                    });
                }
            }
        }});
        this.body.add(new Component[]{content});
    }
}

