/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.SingleThemeProvider;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleRequestCycleListener;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.annotations.Resource;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.pages.Login;
import org.apache.syncope.client.console.pages.MustChangePassword;
import org.apache.syncope.client.console.themes.AdminLTE;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.common.lib.PropertyUtils;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.rest.api.service.DomainService;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebApplication;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.CsrfPreventionRequestCycleListener;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryResourceReference;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeConsoleApplication
extends AuthenticatedWebApplication {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeConsoleApplication.class);
    private static final String CONSOLE_PROPERTIES = "console.properties";
    public static final List<Locale> SUPPORTED_LOCALES = Collections.unmodifiableList(Arrays.asList(Locale.ENGLISH, Locale.ITALIAN, new Locale("pt", "BR"), new Locale("ru"), Locale.JAPANESE));
    private String site;
    private String anonymousUser;
    private String anonymousKey;
    private String reconciliationReportKey;
    private String scheme;
    private String host;
    private String port;
    private String rootPath;
    private String useGZIPCompression;
    private Integer maxUploadFileSizeMB;
    private Integer maxWaitTime;
    private Integer corePoolSize;
    private Integer maxPoolSize;
    private Integer queueCapacity;
    private List<String> domains;
    private Map<String, Class<? extends BasePage>> pageClasses;

    public static SyncopeConsoleApplication get() {
        return (SyncopeConsoleApplication)WebApplication.get();
    }

    protected void populatePageClasses(Properties props) {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            if (!name.startsWith("page.")) continue;
            try {
                Class clazz = ClassUtils.getClass((String)props.getProperty(name));
                if (BasePage.class.isAssignableFrom(clazz)) {
                    this.pageClasses.put(StringUtils.substringAfter((String)"page.", (String)name), clazz);
                    continue;
                }
                LOG.warn("{} does not extend {}, ignoring...", (Object)clazz.getName(), (Object)BasePage.class.getName());
            }
            catch (ClassNotFoundException e) {
                LOG.error("While looking for class identified by property '{}'", (Object)name, (Object)e);
            }
        }
    }

    protected void init() {
        super.init();
        Properties props = (Properties)PropertyUtils.read(((Object)((Object)this)).getClass(), (String)CONSOLE_PROPERTIES, (String)"console.directory").getLeft();
        this.site = props.getProperty("site");
        Args.notNull((Object)this.site, (String)"<site>");
        this.anonymousUser = props.getProperty("anonymousUser");
        Args.notNull((Object)this.anonymousUser, (String)"<anonymousUser>");
        this.anonymousKey = props.getProperty("anonymousKey");
        Args.notNull((Object)this.anonymousKey, (String)"<anonymousKey>");
        this.scheme = props.getProperty("scheme");
        Args.notNull((Object)this.scheme, (String)"<scheme>");
        this.host = props.getProperty("host");
        Args.notNull((Object)this.host, (String)"<host>");
        this.port = props.getProperty("port");
        Args.notNull((Object)this.port, (String)"<port>");
        this.rootPath = props.getProperty("rootPath");
        Args.notNull((Object)this.rootPath, (String)"<rootPath>");
        this.useGZIPCompression = props.getProperty("useGZIPCompression");
        Args.notNull((Object)this.useGZIPCompression, (String)"<useGZIPCompression>");
        this.maxUploadFileSizeMB = props.getProperty("maxUploadFileSizeMB") == null ? null : Integer.valueOf(props.getProperty("maxUploadFileSizeMB"));
        this.maxWaitTime = Integer.valueOf(props.getProperty("maxWaitTimeOnApplyChanges", "30"));
        this.corePoolSize = Integer.valueOf(props.getProperty("topology.corePoolSize", "5"));
        this.maxPoolSize = Integer.valueOf(props.getProperty("topology.maxPoolSize", "10"));
        this.queueCapacity = Integer.valueOf(props.getProperty("topology.queueCapacity", "50"));
        String csrf = props.getProperty("csrf");
        this.pageClasses = new HashMap<String, Class<? extends BasePage>>();
        this.populatePageClasses(props);
        this.pageClasses = Collections.unmodifiableMap(this.pageClasses);
        BootstrapSettings settings = new BootstrapSettings();
        settings.setThemeProvider((ThemeProvider)new SingleThemeProvider((ITheme)new AdminLTE()));
        Bootstrap.install((Application)this, (IBootstrapSettings)settings);
        this.getResourceSettings().setUseMinifiedResources(true);
        this.getResourceSettings().setThrowExceptionOnMissingResource(true);
        this.getJavaScriptLibrarySettings().setJQueryReference((ResourceReference)JQueryResourceReference.getV2());
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new MetaDataRoleAuthorizationStrategy((IRoleCheckingStrategy)this));
        ClassPathScanImplementationLookup lookup = (ClassPathScanImplementationLookup)this.getServletContext().getAttribute("CLASSPATH_LOOKUP");
        lookup.getPageClasses().forEach(cls -> MetaDataRoleAuthorizationStrategy.authorize((Class)cls, (String)"AUTHENTICATED"));
        this.getMarkupSettings().setStripWicketTags(true);
        this.getMarkupSettings().setCompressWhitespace(true);
        if (BooleanUtils.toBoolean((String)csrf)) {
            this.getRequestCycleListeners().add((Object)new CsrfPreventionRequestCycleListener());
        }
        this.getRequestCycleListeners().add((Object)new SyncopeConsoleRequestCycleListener());
        this.mountPage("/login", this.getSignInPageClass());
        try {
            this.reconciliationReportKey = props.getProperty("reconciliationReportKey");
        }
        catch (NumberFormatException e) {
            LOG.error("While parsing reconciliationReportKey", (Throwable)e);
        }
        Args.notNull((Object)this.reconciliationReportKey, (String)"<reconciliationReportKey>");
        for (Class<? extends AbstractResource> resource : lookup.getResources()) {
            Resource annotation = resource.getAnnotation(Resource.class);
            try {
                final AbstractResource instance = resource.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.mountResource(annotation.path(), new ResourceReference(annotation.key()){
                    private static final long serialVersionUID = -128426276529456602L;

                    public IResource getResource() {
                        return instance;
                    }
                });
            }
            catch (Exception e) {
                LOG.error("Could not instantiate {}", (Object)resource.getName(), (Object)e);
            }
        }
        if (this.getDebugSettings().isAjaxDebugModeEnabled()) {
            this.getDebugSettings().setComponentPathAttributeName("syncope-path");
        }
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return SyncopeConsoleSession.class;
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        return Login.class;
    }

    public Class<? extends Page> getHomePage() {
        return AuthenticatedWebSession.get().isSignedIn() && SyncopeConsoleSession.get().getSelfTO().isMustChangePassword() ? MustChangePassword.class : Dashboard.class;
    }

    public Class<? extends BasePage> getPageClass(String key) {
        return this.pageClasses.get(key);
    }

    public String getSite() {
        return this.site;
    }

    public String getAnonymousUser() {
        return this.anonymousUser;
    }

    public String getAnonymousKey() {
        return this.anonymousKey;
    }

    public String getReconciliationReportKey() {
        return this.reconciliationReportKey;
    }

    public Integer getMaxUploadFileSizeMB() {
        return this.maxUploadFileSizeMB;
    }

    public Integer getMaxWaitTimeInSeconds() {
        return this.maxWaitTime;
    }

    public Integer getCorePoolSize() {
        return this.corePoolSize;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public Integer getQueueCapacity() {
        return this.queueCapacity;
    }

    public SyncopeClientFactoryBean newClientFactory() {
        return new SyncopeClientFactoryBean().setAddress(this.scheme + "://" + this.host + ":" + this.port + StringUtils.prependIfMissing((String)this.rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0])).setUseCompression(BooleanUtils.toBoolean((String)this.useGZIPCompression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDomains() {
        Logger logger = LOG;
        synchronized (logger) {
            if (this.domains == null) {
                this.domains = ((DomainService)this.newClientFactory().create((AuthenticationHandler)new AnonymousAuthenticationHandler(this.anonymousUser, this.anonymousKey)).getService(DomainService.class)).list().stream().map(EntityTO::getKey).collect(Collectors.toList());
                this.domains.add(0, "Master");
                this.domains = ListUtils.unmodifiableList(this.domains);
            }
        }
        return this.domains;
    }
}

