/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.beans.UserRequestFormQuery;
import org.apache.syncope.common.rest.api.beans.UserRequestQuery;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.syncope.core.logic.UserRequestLogic;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.rest.cxf.service.AbstractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRequestServiceImpl
extends AbstractServiceImpl
implements UserRequestService {
    @Autowired
    private UserRequestLogic logic;
    @Autowired
    private UserDAO userDAO;

    public PagedResult<UserRequest> list(UserRequestQuery query) {
        if (query.getUser() != null) {
            query.setUser(this.getActualKey((AnyDAO)this.userDAO, query.getUser()));
        }
        Pair result = this.logic.list(query.getUser(), query.getPage().intValue(), query.getSize().intValue(), this.getOrderByClauses(query.getOrderBy()));
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public UserRequest start(String bpmnProcess, String user) {
        return user == null ? this.logic.start(bpmnProcess) : this.logic.start(bpmnProcess, this.getActualKey((AnyDAO)this.userDAO, user));
    }

    public void cancel(String executionId, String reason) {
        this.logic.cancel(executionId, reason);
    }

    public UserRequestForm claimForm(String taskId) {
        return this.logic.claimForm(taskId);
    }

    public UserRequestForm unclaimForm(String taskId) {
        return this.logic.unclaimForm(taskId);
    }

    public PagedResult<UserRequestForm> getForms(UserRequestFormQuery query) {
        if (query.getUser() != null) {
            query.setUser(this.getActualKey((AnyDAO)this.userDAO, query.getUser()));
        }
        Pair result = this.logic.getForms(query.getUser(), query.getPage().intValue(), query.getSize().intValue(), this.getOrderByClauses(query.getOrderBy()));
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public UserTO submitForm(UserRequestForm form) {
        return this.logic.submitForm(form);
    }
}

