/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.core.request.handler.ComponentNotFoundException;
import org.apache.wicket.core.request.handler.IPageAndComponentProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.feedback.FeedbackDelay;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

public class PageAndComponentProvider
extends PageProvider
implements IPageAndComponentProvider {
    private IRequestableComponent component;
    private String componentPath;

    public PageAndComponentProvider(IRequestablePage page, String componentPath) {
        super(page);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(IRequestablePage page, IRequestableComponent component) {
        super(page);
        Args.notNull((Object)component, (String)"component");
        this.component = component;
    }

    public PageAndComponentProvider(Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, String componentPath) {
        super(pageClass, pageParameters);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(Class<? extends IRequestablePage> pageClass, String componentPath) {
        super(pageClass);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(int pageId, Class<? extends IRequestablePage> pageClass, Integer renderCount, String componentPath) {
        super(pageId, pageClass, renderCount);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(Integer pageId, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, Integer renderCount, String componentPath) {
        super(pageId, pageClass, pageParameters, renderCount);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(int pageId, Integer renderCount, String componentPath) {
        super(pageId, renderCount);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(IRequestablePage page, IRequestableComponent component, PageParameters parameters) {
        super(page);
        Args.notNull((Object)component, (String)"component");
        this.component = component;
        if (parameters != null) {
            this.setPageParameters(parameters);
        }
    }

    @Override
    public IRequestableComponent getComponent() {
        if (this.component == null) {
            IRequestablePage page = this.getPageInstance();
            IRequestableComponent iRequestableComponent = this.component = page != null ? page.get(this.componentPath) : null;
            if (this.component == null && page.isPageStateless()) {
                this.component = this.resolveStatelessPageComponent((Page)page);
            }
        }
        if (this.component == null) {
            throw new ComponentNotFoundException("Could not find component '" + this.componentPath + "' on page '" + this.getPageClass());
        }
        return this.component;
    }

    private IRequestableComponent resolveStatelessPageComponent(Page page) {
        page.internalInitialize();
        Component component = page.get(this.componentPath);
        if (component != null) {
            return component;
        }
        try (FeedbackDelay delay = new FeedbackDelay(page.getRequestCycle());){
            page.beforeRender();
            page.markRendering(false);
        }
        return page.get(this.componentPath);
    }

    @Override
    public String getComponentPath() {
        if (this.componentPath != null) {
            return this.componentPath;
        }
        return this.component.getPageRelativePath();
    }

    private void setComponentPath(String componentPath) {
        Args.notNull((Object)componentPath, (String)"componentPath");
        this.componentPath = componentPath;
    }
}

