/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.UserRequestRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.UserRequest;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class UserRequestDirectoryPanel
extends DirectoryPanel<UserRequest, UserRequest, UserRequestProvider, UserRequestRestClient> {
    private static final long serialVersionUID = -5346161040211617763L;
    private static final String PREF_USER_REQUEST_PAGINATOR_ROWS = "userrequest.paginator.rows";

    public UserRequestDirectoryPanel(String id, PageReference pageReference) {
        super(id, pageReference, true);
        this.disableCheckBoxes();
        this.setFooterVisibility(false);
        this.modal.size(Modal.Size.Large);
        this.restClient = new UserRequestRestClient();
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"USER_REQUEST_LIST");
    }

    protected List<IColumn<UserRequest, String>> getColumns() {
        ArrayList<IColumn<UserRequest, String>> columns = new ArrayList<IColumn<UserRequest, String>>();
        columns.add((IColumn<UserRequest, String>)new PropertyColumn((IModel)new ResourceModel("bpmnProcess"), (Object)"bpmnProcess", "bpmnProcess"));
        columns.add((IColumn<UserRequest, String>)new DatePropertyColumn((IModel)new ResourceModel("startTime"), "startTime", "startTime"));
        columns.add((IColumn<UserRequest, String>)new PropertyColumn((IModel)new ResourceModel("username"), "username"));
        columns.add((IColumn<UserRequest, String>)new PropertyColumn((IModel)new ResourceModel("activityId"), "activityId"));
        return columns;
    }

    public ActionsPanel<UserRequest> getActions(final IModel<UserRequest> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<UserRequest>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, UserRequest ignore) {
                try {
                    ((UserRequestRestClient)UserRequestDirectoryPanel.this.restClient).cancelRequest(((UserRequest)model.getObject()).getExecutionId(), null);
                    SyncopeConsoleSession.get().info((Serializable)((Object)UserRequestDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{UserRequestDirectoryPanel.this.container});
                    UserRequestDirectoryPanel.this.getTogglePanel().close(target);
                }
                catch (SyncopeClientException e) {
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                    DirectoryPanel.LOG.error("While canceling execution {}", (Object)((UserRequest)model.getObject()).getExecutionId(), (Object)e);
                }
                ((BasePage)UserRequestDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "USER_REQUEST_CANCEL", true);
        return panel;
    }

    protected UserRequestProvider dataProvider() {
        return new UserRequestProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return PREF_USER_REQUEST_PAGINATOR_ROWS;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    protected static class UserRequestProvider
    extends DirectoryDataProvider<UserRequest> {
        private static final long serialVersionUID = -1392420250782313734L;
        private final UserRequestRestClient restClient = new UserRequestRestClient();

        public UserRequestProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("startTime", SortOrder.ASCENDING);
        }

        public Iterator<UserRequest> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return this.restClient.getUserRequests((page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }

        public long size() {
            return this.restClient.countUserRequests();
        }

        public IModel<UserRequest> model(final UserRequest request) {
            return new IModel<UserRequest>(){
                private static final long serialVersionUID = -2566070996511906708L;

                public UserRequest getObject() {
                    return request;
                }
            };
        }
    }
}

