/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.task;

import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.core.flowable.task.FlowableServiceTask;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.flowable.engine.delegate.DelegateExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Update
extends FlowableServiceTask {
    @Autowired
    private UserDataBinder dataBinder;
    @Autowired
    private UserDAO userDAO;

    @Override
    protected void doExecute(DelegateExecution execution) {
        UserPatch userPatch = (UserPatch)execution.getVariable("userPatch", UserPatch.class);
        if (userPatch == null || userPatch.isEmpty()) {
            LOG.warn("No actual update is to be performed: null patch");
        } else {
            User user = (User)execution.getVariable("user", User.class);
            user = (User)this.userDAO.save((Any)user);
            PropagationByResource propByRes = this.dataBinder.update(user, userPatch);
            execution.setVariable("user", (Object)user);
            execution.setVariable("propByResource", (Object)propByRes);
        }
    }
}

