/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.task;

import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.core.flowable.task.FlowableServiceTask;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.flowable.engine.delegate.DelegateExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PasswordReset
extends FlowableServiceTask {
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private UserDataBinder dataBinder;

    @Override
    protected void doExecute(DelegateExecution execution) {
        User user = (User)execution.getVariable("user", User.class);
        String token = (String)execution.getVariable("token", String.class);
        String password = (String)execution.getVariable("password", String.class);
        if (!user.checkToken(token)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Wrong token: " + token + " for " + user));
        }
        user.removeToken();
        UserPatch userPatch = new UserPatch();
        userPatch.setKey(user.getKey());
        userPatch.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).resources(this.userDAO.findAllResourceKeys(user.getKey())).value((Object)password)).build());
        PropagationByResource propByRes = this.dataBinder.update(user, userPatch);
        execution.setVariable("user", (Object)user);
        execution.setVariable("userPatch", (Object)userPatch);
        execution.setVariable("propByResource", (Object)propByRes);
    }
}

