/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.to.WorkflowTask;
import org.apache.syncope.common.lib.to.WorkflowTaskExecInput;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.flowable.api.UserRequestHandler;
import org.apache.syncope.core.flowable.api.WorkflowTaskManager;
import org.apache.syncope.core.flowable.impl.FlowableRuntimeUtils;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.apache.syncope.core.workflow.java.AbstractUserWorkflowAdapter;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class FlowableUserWorkflowAdapter
extends AbstractUserWorkflowAdapter
implements WorkflowTaskManager {
    @Autowired
    protected DomainProcessEngine engine;
    @Autowired
    protected UserRequestHandler userRequestHandler;

    public String getPrefix() {
        return "ACT_";
    }

    @Override
    public <T> T getVariable(String executionId, String variableName, Class<T> variableClass) {
        return (T)this.engine.getRuntimeService().getVariable(executionId, variableName, variableClass);
    }

    @Override
    public void setVariable(String executionId, String variableName, Object value) {
        this.engine.getRuntimeService().setVariable(executionId, variableName, value);
    }

    protected User lazyLoad(User user) {
        BeanUtils.copyProperties((Object)user, (Object)this.entityFactory.newEntity(User.class));
        return user;
    }

    protected WorkflowResult<Pair<String, Boolean>> doCreate(UserTO userTO, boolean disablePwdPolicyCheck, Boolean enabled, boolean storePassword) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("wfExecutor", AuthContextUtils.getUsername());
        variables.put("userTO", userTO);
        variables.put("enabled", enabled);
        variables.put("storePassword", storePassword);
        ProcessInstance procInst = null;
        try {
            procInst = this.engine.getRuntimeService().startProcessInstanceByKey("userWorkflow", variables);
        }
        catch (FlowableException e) {
            FlowableRuntimeUtils.throwException(e, "While starting userWorkflow instance");
        }
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "wfExecutor");
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "userTO");
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "storePassword");
        User user = (User)this.engine.getRuntimeService().getVariable(procInst.getProcessInstanceId(), "user", User.class);
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "user");
        Boolean updatedEnabled = (Boolean)this.engine.getRuntimeService().getVariable(procInst.getProcessInstanceId(), "enabled", Boolean.class);
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "enabled");
        if (updatedEnabled != null) {
            user.setSuspended(Boolean.valueOf(updatedEnabled == false));
        }
        if (disablePwdPolicyCheck) {
            user.removeClearPassword();
        }
        FlowableRuntimeUtils.updateStatus(this.engine, procInst.getProcessInstanceId(), user);
        User created = (User)this.userDAO.save((Any)user);
        this.engine.getRuntimeService().updateBusinessKey(procInst.getProcessInstanceId(), FlowableRuntimeUtils.getWFProcBusinessKey(created.getKey()));
        Boolean propagateEnable = (Boolean)this.engine.getRuntimeService().getVariable(procInst.getProcessInstanceId(), "propagateEnable", Boolean.class);
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "propagateEnable");
        if (propagateEnable == null) {
            propagateEnable = enabled;
        }
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.CREATE, this.userDAO.findAllResourceKeys(created.getKey()));
        FlowableRuntimeUtils.saveForFormSubmit(this.engine, procInst.getProcessInstanceId(), created, this.dataBinder.getUserTO(created, true), userTO.getPassword(), enabled, propByRes);
        Set<String> tasks = FlowableRuntimeUtils.getPerformedTasks(this.engine, procInst.getProcessInstanceId(), user);
        return new WorkflowResult((Object)Pair.of((Object)created.getKey(), (Object)propagateEnable), propByRes, tasks);
    }

    protected Set<String> doExecuteNextTask(String procInstID, User user, Map<String, Object> moreVariables) {
        Set<String> preTasks = FlowableRuntimeUtils.getPerformedTasks(this.engine, procInstID, user);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("wfExecutor", AuthContextUtils.getUsername());
        variables.put("user", this.lazyLoad(user));
        if (moreVariables != null && !moreVariables.isEmpty()) {
            variables.putAll(moreVariables);
        }
        List tasks = ((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(procInstID)).list();
        String task = null;
        if (tasks.size() == 1) {
            try {
                this.engine.getTaskService().complete(((Task)tasks.get(0)).getId(), variables);
                task = ((Task)tasks.get(0)).getTaskDefinitionKey();
            }
            catch (FlowableException e) {
                FlowableRuntimeUtils.throwException(e, "While completing task '" + ((Task)tasks.get(0)).getName() + "' for " + user);
            }
        } else {
            LOG.warn("Expected a single task, found {}", (Object)tasks.size());
        }
        Set<String> postTasks = FlowableRuntimeUtils.getPerformedTasks(this.engine, procInstID, user);
        postTasks.removeAll(preTasks);
        if (task != null) {
            postTasks.add(task);
        }
        return postTasks;
    }

    protected WorkflowResult<String> doActivate(User user, String token) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        HashMap<String, Object> variables = new HashMap<String, Object>(2);
        variables.put("token", token);
        variables.put("task", "activate");
        Set<String> tasks = this.doExecuteNextTask(procInstID, user, variables);
        FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
        User updated = (User)this.userDAO.save((Any)user);
        variables.keySet().forEach(key -> this.engine.getRuntimeService().removeVariable(procInstID, key));
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        return new WorkflowResult((Object)updated.getKey(), null, tasks);
    }

    protected WorkflowResult<Pair<UserPatch, Boolean>> doUpdate(User user, UserPatch userPatch) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        UserPatch patchBeforeUpdate = (UserPatch)this.engine.getRuntimeService().getVariable(procInstID, "userPatch", UserPatch.class);
        PropagationByResource propByResBeforeUpdate = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByResource", PropagationByResource.class);
        boolean inFormTask = FlowableRuntimeUtils.getFormTask(this.engine, procInstID) != null;
        HashMap<String, Object> variables = new HashMap<String, Object>(2);
        variables.put("userPatch", userPatch);
        variables.put("task", "update");
        Set<String> tasks = this.doExecuteNextTask(procInstID, user, variables);
        FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
        User updated = (User)this.userDAO.save((Any)user);
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        this.engine.getRuntimeService().removeVariable(procInstID, "task");
        if (inFormTask) {
            if (patchBeforeUpdate == null) {
                this.engine.getRuntimeService().removeVariable(procInstID, "userPatch");
            } else {
                this.engine.getRuntimeService().setVariable(procInstID, "userPatch", (Object)patchBeforeUpdate);
            }
        }
        boolean bl = inFormTask = FlowableRuntimeUtils.getFormTask(this.engine, procInstID) != null;
        if (!inFormTask) {
            this.engine.getRuntimeService().removeVariable(procInstID, "userPatch");
        }
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByResource", PropagationByResource.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propByResource");
        FlowableRuntimeUtils.saveForFormSubmit(this.engine, procInstID, updated, this.dataBinder.getUserTO(updated, true), userPatch.getPassword() == null ? null : (String)userPatch.getPassword().getValue(), null, propByResBeforeUpdate == null ? propByRes : propByResBeforeUpdate);
        Boolean propagateEnable = (Boolean)this.engine.getRuntimeService().getVariable(procInstID, "propagateEnable", Boolean.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propagateEnable");
        return new WorkflowResult((Object)Pair.of((Object)userPatch, (Object)propagateEnable), propByRes, tasks);
    }

    protected WorkflowResult<String> doSuspend(User user) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        Set<String> performedTasks = this.doExecuteNextTask(procInstID, user, Collections.singletonMap("task", "suspend"));
        FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
        User updated = (User)this.userDAO.save((Any)user);
        this.engine.getRuntimeService().removeVariable(procInstID, "task");
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        return new WorkflowResult((Object)updated.getKey(), null, performedTasks);
    }

    protected WorkflowResult<String> doReactivate(User user) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        Set<String> performedTasks = this.doExecuteNextTask(procInstID, user, Collections.singletonMap("task", "reactivate"));
        FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
        User updated = (User)this.userDAO.save((Any)user);
        this.engine.getRuntimeService().removeVariable(procInstID, "task");
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        return new WorkflowResult((Object)updated.getKey(), null, performedTasks);
    }

    protected void doRequestPasswordReset(User user) {
        HashMap<String, Object> variables = new HashMap<String, Object>(3);
        variables.put("userTO", this.dataBinder.getUserTO(user, true));
        variables.put("task", "requestPasswordReset");
        variables.put("event", "requestPasswordReset");
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        this.doExecuteNextTask(procInstID, user, variables);
        this.userDAO.save((Any)user);
        variables.keySet().forEach(key -> this.engine.getRuntimeService().removeVariable(procInstID, key));
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
    }

    protected WorkflowResult<Pair<UserPatch, Boolean>> doConfirmPasswordReset(User user, String token, String password) {
        HashMap<String, Object> variables = new HashMap<String, Object>(5);
        variables.put("token", token);
        variables.put("password", password);
        variables.put("userTO", this.dataBinder.getUserTO(user, true));
        variables.put("task", "confirmPasswordReset");
        variables.put("event", "confirmPasswordReset");
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        Set<String> tasks = this.doExecuteNextTask(procInstID, user, variables);
        this.userDAO.save((Any)user);
        variables.keySet().forEach(key -> this.engine.getRuntimeService().removeVariable(procInstID, key));
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByResource", PropagationByResource.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propByResource");
        UserPatch updatedPatch = (UserPatch)this.engine.getRuntimeService().getVariable(procInstID, "userPatch", UserPatch.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "userPatch");
        Boolean propagateEnable = (Boolean)this.engine.getRuntimeService().getVariable(procInstID, "propagateEnable", Boolean.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propagateEnable");
        return new WorkflowResult((Object)Pair.of((Object)updatedPatch, (Object)propagateEnable), propByRes, tasks);
    }

    protected void doDelete(User user) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        this.doExecuteNextTask(procInstID, user, Collections.singletonMap("task", "delete"));
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.DELETE, this.userDAO.findAllResourceKeys(user.getKey()));
        if (this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstID).active().list().isEmpty()) {
            this.userDAO.delete(user.getKey());
            if (!this.engine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(procInstID).list().isEmpty()) {
                this.engine.getHistoryService().deleteHistoricProcessInstance(procInstID);
            }
        } else {
            FlowableRuntimeUtils.saveForFormSubmit(this.engine, procInstID, user, this.dataBinder.getUserTO(user, true), null, null, propByRes);
            FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
            this.userDAO.save((Any)user);
            this.engine.getRuntimeService().removeVariable(procInstID, "task");
            this.engine.getRuntimeService().removeVariable(procInstID, "user");
            this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        }
    }

    @Override
    public WorkflowResult<String> executeNextTask(WorkflowTaskExecInput workflowTaskExecInput) {
        User user = (User)this.userDAO.authFind(workflowTaskExecInput.getUserKey());
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("userTO", this.dataBinder.getUserTO(user, true));
        variables.putAll(workflowTaskExecInput.getVariables());
        Set<String> performedTasks = this.doExecuteNextTask(procInstID, user, variables);
        FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
        user = (User)this.userDAO.save((Any)user);
        this.engine.getRuntimeService().setVariable(procInstID, "userTO", (Object)this.dataBinder.getUserTO(user, true));
        if (this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstID).active().list().isEmpty()) {
            this.userDAO.delete(user.getKey());
            if (!this.engine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(procInstID).list().isEmpty()) {
                this.engine.getHistoryService().deleteHistoricProcessInstance(procInstID);
            }
        } else {
            PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByResource", PropagationByResource.class);
            FlowableRuntimeUtils.saveForFormSubmit(this.engine, procInstID, user, this.dataBinder.getUserTO(user, true), null, null, propByRes);
        }
        return new WorkflowResult((Object)user.getKey(), null, performedTasks);
    }

    protected void navigateAvailableTasks(FlowElement flow, List<String> availableTasks) {
        if (flow instanceof Gateway) {
            ((Gateway)flow).getOutgoingFlows().forEach(subflow -> this.navigateAvailableTasks((FlowElement)subflow, availableTasks));
        } else if (flow instanceof SequenceFlow) {
            this.navigateAvailableTasks(((SequenceFlow)flow).getTargetFlowElement(), availableTasks);
        } else if (flow instanceof org.flowable.bpmn.model.Task) {
            availableTasks.add(flow.getId());
        } else {
            LOG.debug("Unexpected flow found: {}", (Object)flow);
        }
    }

    @Override
    public List<WorkflowTask> getAvailableTasks(String userKey) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, userKey);
        ArrayList availableTasks = new ArrayList();
        try {
            Task currentTask = (Task)((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(procInstID)).singleResult();
            Process process = (Process)this.engine.getRepositoryService().getBpmnModel(FlowableRuntimeUtils.getLatestProcDefByKey(this.engine, "userWorkflow").getId()).getProcesses().get(0);
            process.getFlowElements().stream().filter(SequenceFlow.class::isInstance).map(SequenceFlow.class::cast).filter(sequenceFlow -> sequenceFlow.getSourceRef().equals(currentTask.getTaskDefinitionKey())).forEach(sequenceFlow -> this.navigateAvailableTasks(sequenceFlow.getTargetFlowElement(), availableTasks));
        }
        catch (FlowableException e) {
            throw new WorkflowException("While reading available tasks for workflow instance " + procInstID, (Throwable)e);
        }
        return availableTasks.stream().map(input -> {
            WorkflowTask workflowTaskTO = new WorkflowTask();
            workflowTaskTO.setName(input);
            return workflowTaskTO;
        }).collect(Collectors.toList());
    }
}

